/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.radio;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebRadioGroup;
import io.perfeccionista.framework.pagefactory.extractor.radio.WebRadioButtonValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.radio.WebRadioGroupMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.radio.WebRadioGroupFilter;
import io.perfeccionista.framework.pagefactory.filter.radio.WebRadioGroupFilterBuilder;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import io.perfeccionista.framework.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRadioGroupSingleIndexedResult<T>
implements WebSingleIndexedResult<T, WebRadioGroup> {
    private final WebRadioGroup element;
    private final WebRadioGroupFilterBuilder filterBuilder;
    private final WebRadioButtonValueExtractor<T> extractor;

    private WebRadioGroupSingleIndexedResult(WebRadioGroup element, WebRadioGroupFilterBuilder filterBuilder, WebRadioButtonValueExtractor<T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <T> WebRadioGroupSingleIndexedResult<T> of(@NotNull WebRadioGroup element, @NotNull WebRadioGroupFilterBuilder filterBuilder, @NotNull WebRadioButtonValueExtractor<T> extractor) {
        return new WebRadioGroupSingleIndexedResult<T>(element, filterBuilder, extractor);
    }

    public static <T> WebRadioGroupSingleIndexedResult<T> of(@NotNull WebRadioGroup element, @NotNull WebRadioButtonValueExtractor<T> extractor) {
        return new WebRadioGroupSingleIndexedResult<T>(element, Web.emptyWebRadioButtonFilter(), extractor);
    }

    @Override
    @NotNull
    public WebRadioGroup getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public T getResult() {
        WebRadioGroupFilter webRadioGroupFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webRadioGroupFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return extractedValues.values().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    @NotNull
    public T getNotNullResult() {
        WebRadioGroupFilter webRadioGroupFilter = this.filterBuilder.build(this.element);
        return (T)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webRadioGroupFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            Map.Entry extractedEntry = (Map.Entry)extractedValues.entrySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
            Object maybeNullValue = extractedEntry.getValue();
            if (Objects.isNull(maybeNullValue)) {
                throw ResultVerification.assertionError((String)PageFactoryApiMessages.FILTERED_ELEMENT_CONTAINS_NULL_RESULT.getMessage(new Object[]{extractedEntry.getKey()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
            return maybeNullValue;
        });
    }

    @Override
    public int getIndex() {
        WebRadioGroupFilter webRadioGroupFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetIndex", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webRadioGroupFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return (Integer)extractedValues.keySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    public WebSingleIndexedResult<T, WebRadioGroup> should(WebMultipleIndexedResultMatcher<T> matcher) {
        WebRadioGroupMultipleIndexedResult<T> result = WebRadioGroupMultipleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
        matcher.check(result);
        return this;
    }
}

