/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.list;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.SingleResultCreating;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListMultipleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterBuilder;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import io.perfeccionista.framework.utils.StringUtils;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListSingleIndexedResult<R, T extends WebBlock>
implements WebSingleIndexedResult<R, WebList<T>> {
    private final WebList<T> element;
    private final WebListFilterBuilder<T> filterBuilder;
    private final WebListBlockValueExtractor<R, T> extractor;

    private WebListSingleIndexedResult(@NotNull WebList<T> element, @NotNull WebListFilterBuilder<T> filterBuilder, @NotNull WebListBlockValueExtractor<R, T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <R, T extends WebBlock> WebListSingleIndexedResult<R, T> of(@NotNull WebList<T> element, @NotNull WebListFilterBuilder<T> filterBuilder, @NotNull WebListBlockValueExtractor<R, T> extractor) {
        return new WebListSingleIndexedResult<R, T>(element, filterBuilder, extractor);
    }

    public static <R, T extends WebBlock> WebListSingleIndexedResult<R, T> of(@NotNull WebList<T> element, @NotNull WebListBlockValueExtractor<R, T> extractor) {
        return new WebListSingleIndexedResult<R, T>(element, Web.emptyWebListFilter(), extractor);
    }

    @Override
    @NotNull
    public WebList<T> getElement() {
        return this.element;
    }

    @Override
    @Nullable
    public R getResult() {
        WebListFilter<T> webListFilter = this.filterBuilder.build(this.element);
        return (R)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return extractedValues.values().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    @NotNull
    public R getNotNullResult() {
        WebListFilter<T> webListFilter = this.filterBuilder.build(this.element);
        return (R)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValue", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            Map.Entry extractedEntry = (Map.Entry)extractedValues.entrySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
            Object maybeNullValue = extractedEntry.getValue();
            if (Objects.isNull(maybeNullValue)) {
                throw ResultVerification.assertionError((String)PageFactoryApiMessages.FILTERED_ELEMENT_CONTAINS_NULL_RESULT.getMessage(new Object[]{extractedEntry.getKey()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
            }
            return maybeNullValue;
        });
    }

    @Override
    public int getIndex() {
        WebListFilter<T> webListFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetIndex", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> {
            Map extractedValues = this.extractor.extractValues(webListFilter);
            if (extractedValues.size() > 1) {
                throw SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_MORE_THAN_ONE_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Values", (String)StringUtils.indexesToString(extractedValues.keySet())));
            }
            return (Integer)extractedValues.keySet().stream().findFirst().orElseThrow(() -> SingleResultCreating.exception((String)PageFactoryApiMessages.SINGLE_RESULT_HAS_NO_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
        });
    }

    @Override
    public WebSingleIndexedResult<R, WebList<T>> should(WebMultipleIndexedResultMatcher<R> matcher) {
        WebListMultipleIndexedResult<R, T> result = WebListMultipleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
        matcher.check(result);
        return this;
    }
}

