/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.list;

import io.perfeccionista.framework.Web;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListSingleIndexedResult;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilterBuilder;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.result.WebSingleIndexedResult;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WebListMultipleIndexedResult<R, T extends WebBlock>
implements WebMultipleIndexedResult<R, WebList<T>> {
    private final WebList<T> element;
    private final WebListFilterBuilder<T> filterBuilder;
    private final WebListBlockValueExtractor<R, T> extractor;

    private WebListMultipleIndexedResult(WebList<T> element, WebListFilterBuilder<T> filterBuilder, WebListBlockValueExtractor<R, T> extractor) {
        this.element = element;
        this.filterBuilder = filterBuilder;
        this.extractor = extractor;
    }

    public static <R, T extends WebBlock> WebListMultipleIndexedResult<R, T> of(@NotNull WebList<T> element, @NotNull WebListFilterBuilder<T> filterBuilder, @NotNull WebListBlockValueExtractor<R, T> extractor) {
        return new WebListMultipleIndexedResult<R, T>(element, filterBuilder, extractor);
    }

    public static <R, T extends WebBlock> WebListMultipleIndexedResult<R, T> of(@NotNull WebList<T> element, @NotNull WebListBlockValueExtractor<R, T> extractor) {
        return new WebListMultipleIndexedResult<R, T>(element, Web.emptyWebListFilter(), extractor);
    }

    @Override
    @NotNull
    public WebList<T> getElement() {
        return this.element;
    }

    @Override
    public Map<Integer, R> getResults() {
        return (Map)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetValues", (Object[])new Object[]{this.element, this.filterBuilder, this.extractor}), () -> this.extractor.extractValues(this.filterBuilder.build(this.element)));
    }

    @Override
    public int getSize() {
        WebListFilter webListFilter = this.filterBuilder.build(this.element);
        return (Integer)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetSize", (Object[])new Object[]{this.element, this.filterBuilder}), () -> webListFilter.getFilterResult().getIndexes().size());
    }

    @Override
    public WebMultipleIndexedResult<R, WebList<T>> should(WebMultipleIndexedResultMatcher<R> matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    @NotNull
    public WebSingleIndexedResult<R, WebList<T>> singleResult() {
        return WebListSingleIndexedResult.of(this.element, this.filterBuilder, this.extractor);
    }
}

