/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.list;

import io.perfeccionista.framework.pagefactory.WebPageService;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class WebListBlockExtractor<R extends WebBlock, T extends WebBlock>
implements WebListBlockValueExtractor<R, T> {
    private final Class<R> blockClass;

    public WebListBlockExtractor(@NotNull Class<R> blockClass) {
        this.blockClass = blockClass;
    }

    @Override
    public Map<Integer, R> extractValues(@NotNull WebListFilter<T> filter) {
        FilterResult filterResult = filter.getFilterResult();
        WebList element = (WebList)filter.getElement();
        WebPageFactory webPageFactory = ((WebPageService)element.getEnvironment().getService(WebPageService.class)).getWebPageFactory();
        return webPageFactory.createWebListBlocks(element, filterResult).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (WebBlock)entry.getValue()));
    }
}

