/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.list;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetStringAttributeValueOperationType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebListBlockElementPropertyValueExtractor<T extends WebBlock>
implements WebListBlockValueExtractor<String, T> {
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final String propertyName;

    public WebListBlockElementPropertyValueExtractor(@NotNull String elementPath, @NotNull String propertyName) {
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.propertyName = propertyName;
    }

    public WebListBlockElementPropertyValueExtractor(@NotNull WebChildElement elementFrame, @NotNull String propertyName) {
        this.elementPath = null;
        this.elementFrame = elementFrame;
        this.propertyName = propertyName;
    }

    @Override
    public Map<Integer, String> extractValues(@NotNull WebListFilter<T> filter) {
        WebElementOperation<String> operation;
        FilterResult filterResult = filter.getFilterResult();
        Set indexes = filterResult.getIndexes();
        String hash = filterResult.getHash();
        WebList element = (WebList)filter.getElement();
        WebLocatorChain listLocatorChain = element.getLocatorChain().updateLastLocator(locator -> locator.setCalculateHash(true)).updateLastLocator(locator -> locator.setExpectedHash(hash)).addLastLocator(element.getRequiredLocator("LI")).updateLastLocator(locator -> locator.setIndexes(indexes));
        WebChildElement elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod());
        Optional optionalPropertyHolder = elementToFilter.getProperty(this.propertyName);
        if (optionalPropertyHolder.isPresent()) {
            WebElementPropertyHolder propertyHolder = (WebElementPropertyHolder)optionalPropertyHolder.get();
            operation = propertyHolder.getOperation(elementToFilter);
        } else {
            WebGetStringAttributeValueOperationType operationType = WebGetStringAttributeValueOperationType.of(elementToFilter, this.propertyName);
            operation = WebElementOperationHandler.of(elementToFilter, operationType, this.propertyName).getOperation();
        }
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<String> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        return operationResult.getResults();
    }
}

