/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.extractor.list;

import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.base.PerfeccionistaRuntimeException;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebList;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.methods.WebComponentAvailable;
import io.perfeccionista.framework.pagefactory.extractor.list.WebListBlockValueExtractor;
import io.perfeccionista.framework.pagefactory.filter.FilterResult;
import io.perfeccionista.framework.pagefactory.filter.list.WebListFilter;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsDisplayedOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebListBlockElementComponentDisplayedMarkExtractor<T extends WebBlock>
implements WebListBlockValueExtractor<Boolean, T> {
    private final String elementPath;
    private final WebChildElement elementFrame;
    private final String componentName;

    public WebListBlockElementComponentDisplayedMarkExtractor(@NotNull String elementPath, @NotNull String componentName) {
        this.elementPath = elementPath;
        this.elementFrame = null;
        this.componentName = componentName;
    }

    public WebListBlockElementComponentDisplayedMarkExtractor(@NotNull WebComponentAvailable elementFrame, @NotNull String componentName) {
        this.elementPath = null;
        this.elementFrame = (WebChildElement)elementFrame;
        this.componentName = componentName;
    }

    @Override
    public Map<Integer, Boolean> extractValues(@NotNull WebListFilter<T> filter) {
        FilterResult filterResult = filter.getFilterResult();
        Set indexes = filterResult.getIndexes();
        String hash = filterResult.getHash();
        WebList element = (WebList)filter.getElement();
        WebLocatorChain listLocatorChain = element.getLocatorChain().updateLastLocator(locator -> locator.setCalculateHash(true)).updateLastLocator(locator -> locator.setExpectedHash(hash)).addLastLocator(element.getRequiredLocator("LI")).updateLastLocator(locator -> locator.setIndexes(indexes));
        WebChildElement elementToFilter = this.elementPath != null ? element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByPath(this.elementPath, WebChildElement.class) : element.getWebListFrame().getMappedBlockFrame().getElementRegistry().getRequiredElementByMethod(this.elementFrame.getElementIdentifier().getElementMethod());
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(elementToFilter);
        WebElementOperation<Boolean> operation = WebElementIsDisplayedOperationHandler.of(elementToFilter, operationType, this.componentName).getOperation();
        operation.getLocatorChain().addFirstLocators(listLocatorChain);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            PerfeccionistaRuntimeException exception = exceptionMapper.mapElementException(element, (RuntimeException)originalException);
            throw exception.addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        });
        return operationResult.getResults();
    }
}

