/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.states.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class WebElementStateRegistry {
    private final Map<String, WebElementStateHolder> states;

    private WebElementStateRegistry(Map<String, WebElementStateHolder> states) {
        this.states = states;
    }

    public static WebElementStateRegistry of(Map<String, WebElementStateHolder> states) {
        return new WebElementStateRegistry(states);
    }

    public boolean containsState(String stateName) {
        return this.states.containsKey(stateName);
    }

    public Optional<WebElementStateHolder> getState(String stateName) {
        return Optional.ofNullable(this.states.get(stateName));
    }

    public Stream<Map.Entry<String, WebElementStateHolder>> stream() {
        return this.states.entrySet().stream();
    }

    public void forEach(BiConsumer<String, WebElementStateHolder> consumer) {
        this.states.forEach(consumer);
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.states.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> rootNode.set((String)entry.getKey(), ((WebElementStateHolder)entry.getValue()).toJson()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

