/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.states.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateExtractor;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementStateHolder
implements JsonSerializable {
    private final String name;
    private final WebLocatorHolder locatorHolder;
    private final WebElementStateExtractor stateExtractor;

    private WebElementStateHolder(String name, WebLocatorHolder locatorHolder, WebElementStateExtractor stateExtractor) {
        this.name = name;
        this.locatorHolder = locatorHolder;
        this.stateExtractor = stateExtractor;
    }

    public static WebElementStateHolder of(@NotNull String name, @Nullable WebLocatorHolder locatorHolder, @NotNull WebElementStateExtractor stateExtractor) {
        return new WebElementStateHolder(name, locatorHolder, stateExtractor);
    }

    public String getName() {
        return this.name;
    }

    public Optional<WebLocatorHolder> getLocatorHolder() {
        return Optional.ofNullable(this.locatorHolder);
    }

    public WebElementStateExtractor getStateExtractor() {
        return this.stateExtractor;
    }

    public WebElementOperation<Boolean> getOperation(WebChildElementBase element) {
        return this.stateExtractor.getOperation(element, this.getLocatorHolder());
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("name", this.name);
        rootNode.set("locator", this.locatorHolder == null ? null : this.locatorHolder.setLocatorComponent("STATE").toJson());
        rootNode.put("extractor", this.stateExtractor.getClass().getCanonicalName());
        return rootNode;
    }
}

