/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.registry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.ElementNotFound;
import io.perfeccionista.framework.exceptions.ElementPathNotResolved;
import io.perfeccionista.framework.exceptions.MethodNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.exceptions.messages.UtilsMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentElement;
import io.perfeccionista.framework.utils.CastUtils;
import io.perfeccionista.framework.utils.JsonUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForMethods;
import io.perfeccionista.framework.utils.StringUtils;
import io.perfeccionista.framework.utils.WebElementUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WebElementRegistry
implements JsonSerializable {
    protected Map<String, WebChildElement> elementsByMethodName = new HashMap<String, WebChildElement>();
    protected Map<Method, WebChildElement> elementsByMethod = new HashMap<Method, WebChildElement>();
    protected Map<String, WebChildElement> elementsByName = new HashMap<String, WebChildElement>();
    protected Map<String, Method> innerMethods = new HashMap<String, Method>();

    protected WebElementRegistry(List<WebChildElement> webChildElements) {
        webChildElements.forEach(webChildElement -> webChildElement.getElementIdentifier().addElementsByMethodName(this.elementsByMethodName, (WebChildElement)webChildElement).addElementsByMethod(this.elementsByMethod, (WebChildElement)webChildElement).addElementsByName(this.elementsByName, (WebChildElement)webChildElement));
    }

    public static WebElementRegistry of(@NotNull List<WebChildElement> webChildElements) {
        return new WebElementRegistry(webChildElements);
    }

    public static WebElementRegistry of(@NotNull Map<String, WebBlock> webTableCells) {
        WebElementRegistry webElementRegistry = new WebElementRegistry(new ArrayList<WebChildElement>());
        webTableCells.forEach((webTableColumnName, webTableColumnCell) -> webElementRegistry.elementsByName.put((String)webTableColumnName, (WebChildElement)webTableColumnCell));
        return webElementRegistry;
    }

    public Optional<WebChildElement> getElementByMethod(@NotNull Method method) {
        WebChildElement lookupElement = null;
        if (this.elementsByMethod.containsKey(method)) {
            lookupElement = this.elementsByMethod.get(method);
        } else {
            for (WebChildElement element : this.elementsByMethod.values()) {
                Optional<WebChildElement> result;
                if (!CastUtils.isSubtypeOf((Object)element, WebParentElement.class) || !(result = ((WebParentElement)((Object)element)).getElementRegistry().getElementByMethod(method)).isPresent()) continue;
                lookupElement = result.get();
                break;
            }
        }
        if (lookupElement != null) {
            lookupElement.getElementIdentifier().setLastUsedName(method.getName());
        }
        return Optional.ofNullable(lookupElement);
    }

    public <T extends WebChildElement> Optional<T> getElementByMethod(@NotNull Method method, @NotNull Class<T> elementClass) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByMethod(method);
        if (optionalLookupElement.isPresent()) {
            WebChildElement lookupElement = optionalLookupElement.get();
            return Optional.of(WebElementUtils.castWebChildElement(lookupElement, elementClass));
        }
        return Optional.empty();
    }

    public WebChildElement getRequiredElementByMethod(@NotNull Method method) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByMethod(method);
        if (optionalLookupElement.isPresent()) {
            return optionalLookupElement.get();
        }
        throw ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{method.getName()}));
    }

    public <T extends WebChildElement> T getRequiredElementByMethod(@NotNull Method method, @NotNull Class<T> elementClass) {
        Optional<T> optionalLookupElement = this.getElementByMethod(method, elementClass);
        if (optionalLookupElement.isPresent()) {
            return (T)((WebChildElement)optionalLookupElement.get());
        }
        throw ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{method.getName()}));
    }

    protected Optional<WebChildElement> getElementByMethodName(String methodName) {
        WebChildElement lookupElement = null;
        if (this.elementsByMethodName.containsKey(methodName)) {
            lookupElement = this.elementsByMethodName.get(methodName);
        } else {
            for (WebChildElement element : this.elementsByMethodName.values()) {
                Optional<WebChildElement> result;
                if (!CastUtils.isSubtypeOf((Object)element, WebParentElement.class) || !(result = ((WebParentElement)((Object)element)).getElementRegistry().getElementByMethodName(methodName)).isPresent()) continue;
                lookupElement = result.get();
                break;
            }
        }
        if (lookupElement != null) {
            lookupElement.getElementIdentifier().setLastUsedName(methodName);
        }
        return Optional.ofNullable(lookupElement);
    }

    public <T extends WebChildElement> Optional<T> getElementByMethodName(@NotNull String methodName, @NotNull Class<T> elementClass) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByMethodName(methodName);
        if (optionalLookupElement.isPresent()) {
            WebChildElement lookupElement = optionalLookupElement.get();
            return Optional.of(WebElementUtils.castWebChildElement(lookupElement, elementClass));
        }
        return Optional.empty();
    }

    public Optional<WebChildElement> getElementByPath(@NotNull String elementPath) {
        String[] elementNameSequence = StringUtils.splitPathByArrow((String)elementPath);
        WebChildElement lookupElement = null;
        for (String elementName : elementNameSequence) {
            Optional<WebChildElement> intermediateResult;
            if (null == lookupElement) {
                intermediateResult = this.getElementByName(elementName);
            } else {
                if (!CastUtils.isSubtypeOf(lookupElement, WebParentElement.class)) {
                    throw ElementPathNotResolved.exception((String)PageFactoryApiMessages.ELEMENT_PATH_NOT_RESOLVED.getMessage(new Object[]{elementPath, lookupElement.getClass().getSimpleName()})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(lookupElement));
                }
                intermediateResult = ((WebParentElement)((Object)lookupElement)).getElementRegistry().getElementByName(elementName);
            }
            if (!intermediateResult.isPresent()) {
                return Optional.empty();
            }
            lookupElement = intermediateResult.get();
        }
        return Optional.ofNullable(lookupElement);
    }

    public <T extends WebChildElement> Optional<T> getElementByPath(@NotNull String elementPath, @NotNull Class<T> elementClass) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByPath(elementPath);
        if (optionalLookupElement.isPresent()) {
            WebChildElement lookupElement = optionalLookupElement.get();
            return Optional.of(WebElementUtils.castWebChildElement(lookupElement, elementClass));
        }
        return Optional.empty();
    }

    public WebChildElement getRequiredElementByPath(@NotNull String elementPath) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByPath(elementPath);
        if (optionalLookupElement.isPresent()) {
            return optionalLookupElement.get();
        }
        throw ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{elementPath}));
    }

    public <T extends WebChildElement> T getRequiredElementByPath(@NotNull String elementPath, @NotNull Class<T> elementClass) {
        Optional<WebChildElement> optionalLookupElement = this.getElementByPath(elementPath);
        if (optionalLookupElement.isPresent()) {
            WebChildElement lookupElement = optionalLookupElement.get();
            return WebElementUtils.castWebChildElement(lookupElement, elementClass);
        }
        throw ElementNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NOT_FOUND.getMessage(new Object[]{elementPath}));
    }

    protected Optional<WebChildElement> getElementByName(String elementName) {
        WebChildElement lookupElement = null;
        if (this.elementsByName.containsKey(elementName)) {
            lookupElement = this.elementsByName.get(elementName);
        } else {
            for (WebChildElement element : this.elementsByName.values()) {
                Optional<WebChildElement> result;
                if (!CastUtils.isSubtypeOf((Object)element, WebParentElement.class) || !(result = ((WebParentElement)((Object)element)).getElementRegistry().getElementByName(elementName)).isPresent()) continue;
                lookupElement = result.get();
                break;
            }
        }
        if (lookupElement != null) {
            lookupElement.getElementIdentifier().setLastUsedName(elementName);
        }
        return Optional.ofNullable(lookupElement);
    }

    public void invokeMethodByName(String methodName, WebParentElement targetElement, Object ... args) {
        Method method = Optional.ofNullable(this.innerMethods.get(methodName)).orElseThrow(() -> MethodNotFound.exception((String)UtilsMessages.METHOD_NOT_FOUND.getMessage(new Object[]{methodName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(targetElement)));
        ReflectionUtilsForMethods.invokeMethod((Method)method, (Object)targetElement, (Object[])args);
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        ArrayNode methodNamesNode = rootNode.putArray("methodNames");
        this.elementsByMethodName.keySet().forEach(arg_0 -> ((ArrayNode)methodNamesNode).add(arg_0));
        ArrayNode namesNode = rootNode.putArray("names");
        this.elementsByName.keySet().forEach(arg_0 -> ((ArrayNode)namesNode).add(arg_0));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

