/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.properties.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class WebElementPropertyRegistry {
    private final Map<String, WebElementPropertyHolder> properties;

    private WebElementPropertyRegistry(Map<String, WebElementPropertyHolder> properties) {
        this.properties = properties;
    }

    public static WebElementPropertyRegistry of(Map<String, WebElementPropertyHolder> properties) {
        return new WebElementPropertyRegistry(properties);
    }

    public boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public Optional<WebElementPropertyHolder> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public Stream<Map.Entry<String, WebElementPropertyHolder>> stream() {
        return this.properties.entrySet().stream();
    }

    public void forEach(BiConsumer<String, WebElementPropertyHolder> consumer) {
        this.properties.forEach(consumer);
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.properties.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> rootNode.set((String)entry.getKey(), ((WebElementPropertyHolder)entry.getValue()).toJson()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

