/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.properties.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyExtractor;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebElementPropertyHolder
implements JsonSerializable {
    private final String name;
    private final WebLocatorHolder locatorHolder;
    private final WebElementPropertyExtractor propertyExtractor;

    private WebElementPropertyHolder(String name, WebLocatorHolder locatorHolder, WebElementPropertyExtractor propertyExtractor) {
        this.name = name;
        this.locatorHolder = locatorHolder;
        this.propertyExtractor = propertyExtractor;
    }

    public static WebElementPropertyHolder of(@NotNull String name, @Nullable WebLocatorHolder locatorHolder, @NotNull WebElementPropertyExtractor propertyExtractor) {
        return new WebElementPropertyHolder(name, locatorHolder, propertyExtractor);
    }

    public String getName() {
        return this.name;
    }

    public Optional<WebLocatorHolder> getLocatorHolder() {
        return Optional.ofNullable(this.locatorHolder);
    }

    public WebElementPropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public WebElementOperation<String> getOperation(WebChildElementBase element) {
        return this.propertyExtractor.getOperation(element, this.getLocatorHolder());
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("name", this.name);
        rootNode.set("locator", this.locatorHolder == null ? null : this.locatorHolder.setLocatorComponent("PROPERTY").toJson());
        rootNode.put("extractor", this.propertyExtractor.getClass().getCanonicalName());
        return rootNode;
    }
}

