/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.preferences;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.LocatorNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebLocatorConfiguration
implements JsonSerializable {
    private final HashMap<String, WebLocatorHolder> webLocatorHolders = new HashMap();

    private WebLocatorConfiguration() {
    }

    public static WebLocatorConfiguration builder() {
        return new WebLocatorConfiguration();
    }

    public static WebLocatorConfiguration buildFrom(@NotNull WebLocatorConfiguration baseConfiguration) {
        WebLocatorConfiguration configuration = new WebLocatorConfiguration();
        baseConfiguration.stream().forEach(entry -> configuration.set((String)entry.getKey(), (WebLocatorHolder)entry.getValue()));
        return configuration;
    }

    public WebLocatorConfiguration set(@NotNull String locatorName, @NotNull WebLocatorHolder locatorHolder) {
        this.webLocatorHolders.put(locatorName, locatorHolder);
        return this;
    }

    public WebLocatorConfiguration setIfNotPresent(@NotNull String locatorName, @NotNull WebLocatorHolder locatorHolder) {
        if (!this.webLocatorHolders.containsKey(locatorName)) {
            this.webLocatorHolders.put(locatorName, locatorHolder);
        }
        return this;
    }

    public WebLocatorConfiguration setFrom(@NotNull WebLocatorConfiguration configuration) {
        configuration.stream().forEach(entry -> this.set((String)entry.getKey(), (WebLocatorHolder)entry.getValue()));
        return this;
    }

    public WebLocatorConfiguration setFromIfNotPresent(@NotNull WebLocatorConfiguration configuration) {
        configuration.stream().forEach(entry -> this.setIfNotPresent((String)entry.getKey(), (WebLocatorHolder)entry.getValue()));
        return this;
    }

    public WebLocatorHolder getLocatorHolder(@NotNull String locatorName) {
        return Optional.ofNullable(this.webLocatorHolders.get(locatorName)).orElseThrow(() -> LocatorNotFound.exception((String)PageFactoryApiMessages.ELEMENT_LOCATOR_NOT_FOUND.getMessage(new Object[]{locatorName})));
    }

    public Map<String, WebLocatorHolder> asMap() {
        return new HashMap<String, WebLocatorHolder>(this.webLocatorHolders);
    }

    public Stream<Map.Entry<String, WebLocatorHolder>> stream() {
        return this.webLocatorHolders.entrySet().stream();
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.webLocatorHolders.forEach((name, implementation) -> rootNode.put(name, implementation.getClass().getCanonicalName()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

