/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.preferences;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.EndpointHandlerNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebEndpointHandlerConfiguration
implements JsonSerializable {
    private final HashMap<String, Class<? extends EndpointHandler>> endpointHandlers = new HashMap();

    private WebEndpointHandlerConfiguration() {
    }

    public static WebEndpointHandlerConfiguration builder() {
        return new WebEndpointHandlerConfiguration();
    }

    public static WebEndpointHandlerConfiguration buildFrom(@NotNull WebEndpointHandlerConfiguration baseConfiguration) {
        WebEndpointHandlerConfiguration configuration = new WebEndpointHandlerConfiguration();
        baseConfiguration.stream().forEach(entry -> configuration.set((String)entry.getKey(), (Class)entry.getValue()));
        return configuration;
    }

    public WebEndpointHandlerConfiguration set(@NotNull String actionName, @NotNull Class<? extends EndpointHandler> endpointHandler) {
        this.endpointHandlers.put(actionName, endpointHandler);
        return this;
    }

    public WebEndpointHandlerConfiguration setIfNotPresent(@NotNull String actionName, @NotNull Class<? extends EndpointHandler> endpointHandler) {
        if (!this.endpointHandlers.containsKey(actionName)) {
            this.endpointHandlers.put(actionName, endpointHandler);
        }
        return this;
    }

    public WebEndpointHandlerConfiguration setFrom(@NotNull WebEndpointHandlerConfiguration configuration) {
        configuration.stream().forEach(entry -> this.set((String)entry.getKey(), (Class)entry.getValue()));
        return this;
    }

    public WebEndpointHandlerConfiguration setFromIfNotPresent(@NotNull WebEndpointHandlerConfiguration configuration) {
        configuration.stream().forEach(entry -> this.setIfNotPresent((String)entry.getKey(), (Class)entry.getValue()));
        return this;
    }

    public Class<? extends EndpointHandler> getActionImplementation(@NotNull String actionName) {
        return Optional.ofNullable(this.endpointHandlers.get(actionName)).orElseThrow(() -> EndpointHandlerNotFound.exception((String)PageFactoryApiMessages.ENDPOINT_HANDLER_NOT_FOUND.getMessage(new Object[]{actionName})));
    }

    public Map<String, Class<? extends EndpointHandler>> asMap() {
        return new HashMap<String, Class<? extends EndpointHandler>>(this.endpointHandlers);
    }

    public Stream<Map.Entry<String, Class<? extends EndpointHandler>>> stream() {
        return this.endpointHandlers.entrySet().stream();
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.endpointHandlers.forEach((name, implementation) -> rootNode.put(name, implementation.getCanonicalName()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

