/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.preferences;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.ElementStateNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebElementStateConfiguration
implements JsonSerializable {
    private final HashMap<String, WebElementStateHolder> states = new HashMap();

    private WebElementStateConfiguration() {
    }

    public static WebElementStateConfiguration builder() {
        return new WebElementStateConfiguration();
    }

    public static WebElementStateConfiguration buildFrom(@NotNull WebElementStateConfiguration baseConfiguration) {
        WebElementStateConfiguration configuration = new WebElementStateConfiguration();
        baseConfiguration.stream().forEach(entry -> configuration.set((String)entry.getKey(), (WebElementStateHolder)entry.getValue()));
        return configuration;
    }

    public WebElementStateConfiguration set(@NotNull String stateName, @NotNull WebElementStateHolder stateHolder) {
        this.states.put(stateName, stateHolder);
        return this;
    }

    public WebElementStateConfiguration setIfNotPresent(@NotNull String stateName, @NotNull WebElementStateHolder stateHolder) {
        if (!this.states.containsKey(stateName)) {
            this.states.put(stateName, stateHolder);
        }
        return this;
    }

    public WebElementStateConfiguration setFrom(@NotNull WebElementStateConfiguration configuration) {
        configuration.stream().forEach(entry -> this.set((String)entry.getKey(), (WebElementStateHolder)entry.getValue()));
        return this;
    }

    public WebElementStateConfiguration setFromIfNotPresent(@NotNull WebElementStateConfiguration configuration) {
        configuration.stream().forEach(entry -> this.setIfNotPresent((String)entry.getKey(), (WebElementStateHolder)entry.getValue()));
        return this;
    }

    public WebElementStateHolder getStateHolder(@NotNull String stateName) {
        return Optional.ofNullable(this.states.get(stateName)).orElseThrow(() -> ElementStateNotFound.exception((String)PageFactoryApiMessages.ELEMENT_PROPERTY_NOT_FOUND.getMessage(new Object[]{stateName})));
    }

    public Map<String, WebElementStateHolder> asMap() {
        return new HashMap<String, WebElementStateHolder>(this.states);
    }

    public Stream<Map.Entry<String, WebElementStateHolder>> stream() {
        return this.states.entrySet().stream();
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.states.forEach((name, implementation) -> rootNode.put(name, implementation.getClass().getCanonicalName()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

