/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.preferences;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.ElementPropertyNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebElementPropertyConfiguration
implements JsonSerializable {
    private final HashMap<String, WebElementPropertyHolder> properties = new HashMap();

    private WebElementPropertyConfiguration() {
    }

    public static WebElementPropertyConfiguration builder() {
        return new WebElementPropertyConfiguration();
    }

    public static WebElementPropertyConfiguration buildFrom(@NotNull WebElementPropertyConfiguration baseConfiguration) {
        WebElementPropertyConfiguration configuration = new WebElementPropertyConfiguration();
        baseConfiguration.stream().forEach(entry -> configuration.set((String)entry.getKey(), (WebElementPropertyHolder)entry.getValue()));
        return configuration;
    }

    public WebElementPropertyConfiguration set(@NotNull String propertyName, @NotNull WebElementPropertyHolder propertyHolder) {
        this.properties.put(propertyName, propertyHolder);
        return this;
    }

    public WebElementPropertyConfiguration setIfNotPresent(@NotNull String propertyName, @NotNull WebElementPropertyHolder propertyHolder) {
        if (!this.properties.containsKey(propertyName)) {
            this.properties.put(propertyName, propertyHolder);
        }
        return this;
    }

    public WebElementPropertyConfiguration setFrom(@NotNull WebElementPropertyConfiguration configuration) {
        configuration.stream().forEach(entry -> this.set((String)entry.getKey(), (WebElementPropertyHolder)entry.getValue()));
        return this;
    }

    public WebElementPropertyConfiguration setFromIfNotPresent(@NotNull WebElementPropertyConfiguration configuration) {
        configuration.stream().forEach(entry -> this.setIfNotPresent((String)entry.getKey(), (WebElementPropertyHolder)entry.getValue()));
        return this;
    }

    public WebElementPropertyHolder getPropertyHolder(@NotNull String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName)).orElseThrow(() -> ElementPropertyNotFound.exception((String)PageFactoryApiMessages.ELEMENT_PROPERTY_NOT_FOUND.getMessage(new Object[]{propertyName})));
    }

    public Map<String, WebElementPropertyHolder> asMap() {
        return new HashMap<String, WebElementPropertyHolder>(this.properties);
    }

    public Stream<Map.Entry<String, WebElementPropertyHolder>> stream() {
        return this.properties.entrySet().stream();
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.properties.forEach((name, implementation) -> rootNode.put(name, implementation.getClass().getCanonicalName()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

