/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.preferences;

import io.perfeccionista.framework.measurements.Order;
import io.perfeccionista.framework.pagefactory.elements.MappedWebBlockImpl;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.WebBlockImpl;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.WebPageImpl;
import io.perfeccionista.framework.pagefactory.elements.WebTableRowImpl;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebElementPropertyConfiguration;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebElementStateConfiguration;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebEndpointHandlerConfiguration;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebLocatorConfiguration;
import io.perfeccionista.framework.pagefactory.elements.preferences.WebPageFactoryPreferences;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultWebPageFactoryPreferences
implements WebPageFactoryPreferences {
    protected Class<? extends WebPageImpl> webPageImplementationClass = WebPageImpl.class;
    protected Class<? extends WebBlockImpl> webBlockImplementationClass = WebBlockImpl.class;
    protected Class<? extends WebBlockImpl> mappedWebBlockImplementationClass = MappedWebBlockImpl.class;
    protected Class<? extends WebTableRowImpl> webTableRowImplementationClass = WebTableRowImpl.class;
    protected Map<Class<? extends WebChildElement>, Class<? extends WebChildElement>> webElementImplementations = new HashMap<Class<? extends WebChildElement>, Class<? extends WebChildElement>>();
    protected Map<Class<? extends WebChildElement>, Class<? extends WebBlock>> webMappedBlocks = new HashMap<Class<? extends WebChildElement>, Class<? extends WebBlock>>();
    protected Map<Class<? extends WebPage>, WebEndpointHandlerConfiguration> webPageActionConfigurations = new HashMap<Class<? extends WebPage>, WebEndpointHandlerConfiguration>();
    protected Map<Class<? extends WebChildElementBase>, WebEndpointHandlerConfiguration> webElementActionConfigurations = new HashMap<Class<? extends WebChildElementBase>, WebEndpointHandlerConfiguration>();
    protected Map<Class<? extends WebChildElementBase>, WebElementPropertyConfiguration> webElementPropertyConfigurations = new HashMap<Class<? extends WebChildElementBase>, WebElementPropertyConfiguration>();
    protected Map<Class<? extends WebChildElementBase>, WebElementStateConfiguration> webElementStateConfigurations = new HashMap<Class<? extends WebChildElementBase>, WebElementStateConfiguration>();
    protected Map<Class<? extends WebChildElementBase>, WebLocatorConfiguration> webLocatorConfigurations = new HashMap<Class<? extends WebChildElementBase>, WebLocatorConfiguration>();

    @Override
    @NotNull
    public Class<? extends WebPageImpl> getWebPageImplementation() {
        return this.webPageImplementationClass;
    }

    @Override
    public WebPageFactoryPreferences setWebPageImplementation(@NotNull Class<? extends WebPageImpl> webPageImplementationClass) {
        this.webPageImplementationClass = webPageImplementationClass;
        return this;
    }

    @Override
    @NotNull
    public Class<? extends WebBlockImpl> getWebBlockImplementation() {
        return this.webBlockImplementationClass;
    }

    @Override
    public WebPageFactoryPreferences setWebBlockImplementation(@NotNull Class<? extends WebBlockImpl> webBlockImplementation) {
        this.webBlockImplementationClass = webBlockImplementation;
        return this;
    }

    @Override
    @NotNull
    public Class<? extends WebBlockImpl> getMappedWebBlockImplementation() {
        return this.mappedWebBlockImplementationClass;
    }

    @Override
    public WebPageFactoryPreferences setMappedWebBlockImplementation(@NotNull Class<? extends WebBlockImpl> mappedWebBlockImplementation) {
        this.mappedWebBlockImplementationClass = mappedWebBlockImplementation;
        return this;
    }

    @Override
    @NotNull
    public Class<? extends WebTableRowImpl> getWebTableRowImplementation() {
        return this.webTableRowImplementationClass;
    }

    @Override
    public WebPageFactoryPreferences setWebTableRowImplementation(@NotNull Class<? extends WebTableRowImpl> webTableRowImplementation) {
        this.webTableRowImplementationClass = webTableRowImplementation;
        return this;
    }

    @Override
    @Nullable
    public Class<? extends WebChildElement> getWebElementImplementation(@NotNull Class<? extends WebChildElement> webElementType) {
        return this.webElementImplementations.get(webElementType);
    }

    @Override
    public WebPageFactoryPreferences setWebElementImplementations(@NotNull Map<Class<? extends WebChildElement>, Class<? extends WebChildElement>> webElementImplementations) {
        this.webElementImplementations = webElementImplementations;
        return this;
    }

    @Override
    @Nullable
    public Class<? extends WebBlock> getWebMappedBlock(@NotNull Class<? extends WebChildElement> webElementType) {
        Class inheritedInterface;
        Class<? extends WebBlock> webMappedBlock = this.webMappedBlocks.get(webElementType);
        if (Objects.nonNull(webMappedBlock)) {
            return webMappedBlock;
        }
        Iterator iterator = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElement.class, webElementType, (Order)Order.DESC).iterator();
        while (iterator.hasNext() && !Objects.nonNull(webMappedBlock = this.webMappedBlocks.get(inheritedInterface = (Class)iterator.next()))) {
        }
        return webMappedBlock;
    }

    @Override
    public WebPageFactoryPreferences setWebMappedBlocks(@NotNull Map<Class<? extends WebChildElement>, Class<? extends WebBlock>> webMappedBlocks) {
        this.webMappedBlocks = webMappedBlocks;
        return this;
    }

    @Override
    @NotNull
    public WebEndpointHandlerConfiguration getWebPageActionConfiguration(@NotNull Class<? extends WebPage> webPageImplementation) {
        WebEndpointHandlerConfiguration cachedMobilePageActionConfiguration = this.webPageActionConfigurations.get(webPageImplementation);
        if (null != cachedMobilePageActionConfiguration) {
            return cachedMobilePageActionConfiguration;
        }
        WebEndpointHandlerConfiguration webPageActionConfiguration = WebEndpointHandlerConfiguration.builder();
        Deque elementInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebPage.class, webPageImplementation, (Order)Order.DESC);
        elementInterfaces.forEach(inheritedInterface -> webPageActionConfiguration.setFromIfNotPresent(this.getWebPageActionConfiguration((Class<? extends WebPage>)inheritedInterface)));
        this.webPageActionConfigurations.put(webPageImplementation, webPageActionConfiguration);
        return webPageActionConfiguration;
    }

    @Override
    public WebPageFactoryPreferences setWebPageActionConfigurations(@NotNull Map<Class<? extends WebPage>, WebEndpointHandlerConfiguration> webPageActionConfigurations) {
        this.webPageActionConfigurations = webPageActionConfigurations;
        return this;
    }

    @Override
    @NotNull
    public WebEndpointHandlerConfiguration getWebElementActionConfiguration(@NotNull Class<? extends WebChildElementBase> webElementImplementation) {
        WebEndpointHandlerConfiguration cachedWebElementActionConfiguration = this.webElementActionConfigurations.get(webElementImplementation);
        if (null != cachedWebElementActionConfiguration) {
            return cachedWebElementActionConfiguration;
        }
        WebEndpointHandlerConfiguration webElementActionConfiguration = WebEndpointHandlerConfiguration.builder();
        Deque elementInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElementBase.class, webElementImplementation, (Order)Order.DESC);
        elementInterfaces.forEach(inheritedInterface -> webElementActionConfiguration.setFromIfNotPresent(this.getWebElementActionConfiguration((Class<? extends WebChildElementBase>)inheritedInterface)));
        this.webElementActionConfigurations.put(webElementImplementation, webElementActionConfiguration);
        return webElementActionConfiguration;
    }

    @Override
    public WebPageFactoryPreferences setWebElementActionConfigurations(@NotNull Map<Class<? extends WebChildElementBase>, WebEndpointHandlerConfiguration> webElementActionConfigurations) {
        this.webElementActionConfigurations = webElementActionConfigurations;
        return this;
    }

    @Override
    @NotNull
    public WebElementPropertyConfiguration getWebElementPropertyConfiguration(@NotNull Class<? extends WebChildElementBase> webElementImplementation) {
        WebElementPropertyConfiguration cachedWebElementPropertyConfiguration = this.webElementPropertyConfigurations.get(webElementImplementation);
        if (null != cachedWebElementPropertyConfiguration) {
            return cachedWebElementPropertyConfiguration;
        }
        WebElementPropertyConfiguration webElementPropertyConfiguration = WebElementPropertyConfiguration.builder();
        Deque elementInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElementBase.class, webElementImplementation, (Order)Order.DESC);
        elementInterfaces.forEach(inheritedInterface -> webElementPropertyConfiguration.setFromIfNotPresent(this.getWebElementPropertyConfiguration((Class<? extends WebChildElementBase>)inheritedInterface)));
        this.webElementPropertyConfigurations.put(webElementImplementation, webElementPropertyConfiguration);
        return webElementPropertyConfiguration;
    }

    @Override
    public WebPageFactoryPreferences setWebElementPropertyConfigurations(@NotNull Map<Class<? extends WebChildElementBase>, WebElementPropertyConfiguration> webElementPropertyConfigurations) {
        this.webElementPropertyConfigurations = webElementPropertyConfigurations;
        return this;
    }

    @Override
    @NotNull
    public WebElementStateConfiguration getWebElementStateConfiguration(@NotNull Class<? extends WebChildElementBase> webElementImplementation) {
        WebElementStateConfiguration cachedWebElementStateConfiguration = this.webElementStateConfigurations.get(webElementImplementation);
        if (null != cachedWebElementStateConfiguration) {
            return cachedWebElementStateConfiguration;
        }
        WebElementStateConfiguration webElementStateConfiguration = WebElementStateConfiguration.builder();
        Deque elementInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElementBase.class, webElementImplementation, (Order)Order.DESC);
        elementInterfaces.forEach(inheritedInterface -> webElementStateConfiguration.setFromIfNotPresent(this.getWebElementStateConfiguration((Class<? extends WebChildElementBase>)inheritedInterface)));
        this.webElementStateConfigurations.put(webElementImplementation, webElementStateConfiguration);
        return webElementStateConfiguration;
    }

    @Override
    public WebPageFactoryPreferences setWebElementStateConfigurations(@NotNull Map<Class<? extends WebChildElementBase>, WebElementStateConfiguration> webElementStateConfigurations) {
        this.webElementStateConfigurations = webElementStateConfigurations;
        return this;
    }

    @Override
    @NotNull
    public WebLocatorConfiguration getWebLocatorConfiguration(@NotNull Class<? extends WebChildElementBase> webElementImplementation) {
        WebLocatorConfiguration cachedWebLocatorConfiguration = this.webLocatorConfigurations.get(webElementImplementation);
        if (null != cachedWebLocatorConfiguration) {
            return cachedWebLocatorConfiguration;
        }
        WebLocatorConfiguration webLocatorConfiguration = WebLocatorConfiguration.builder();
        Deque elementInterfaces = ReflectionUtilsForClasses.findInheritedInterfaces(WebChildElementBase.class, webElementImplementation, (Order)Order.DESC);
        elementInterfaces.forEach(inheritedInterface -> webLocatorConfiguration.setFromIfNotPresent(this.getWebLocatorConfiguration((Class<? extends WebChildElementBase>)inheritedInterface)));
        this.webLocatorConfigurations.put(webElementImplementation, webLocatorConfiguration);
        return webLocatorConfiguration;
    }

    @Override
    public WebPageFactoryPreferences setWebLocatorConfigurations(@NotNull Map<Class<? extends WebChildElementBase>, WebLocatorConfiguration> webLocatorConfigurations) {
        this.webLocatorConfigurations = webLocatorConfigurations;
        return this;
    }
}

