/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.LocatorNotFound;
import io.perfeccionista.framework.exceptions.MappedBlockNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebTableFrame<T extends WebBlock>
implements JsonSerializable {
    private final WebChildElement element;
    private final Set<String> columns;
    private final Map<String, WebLocatorHolder> headerLocators;
    private final Map<String, WebLocatorHolder> bodyLocators;
    private final Map<String, WebLocatorHolder> footerLocators;
    private final Map<String, T> headers;
    private final Map<String, T> body;
    private final Map<String, T> footers;

    public WebTableFrame(@NotNull WebChildElement element, @NotNull Set<String> columns, @NotNull Map<String, WebLocatorHolder> headerLocators, @NotNull Map<String, WebLocatorHolder> bodyLocators, @NotNull Map<String, WebLocatorHolder> footerLocators, @NotNull Map<String, T> headers, @NotNull Map<String, T> body, @NotNull Map<String, T> footers) {
        this.element = element;
        this.columns = columns;
        this.headerLocators = headerLocators;
        this.bodyLocators = bodyLocators;
        this.footerLocators = footerLocators;
        this.headers = headers;
        this.body = body;
        this.footers = footers;
    }

    public Optional<WebLocatorHolder> getHeaderLocator(@NotNull String columnName) {
        return Optional.ofNullable(this.headerLocators.get(columnName));
    }

    public Optional<WebLocatorHolder> getBodyLocator(@NotNull String columnName) {
        return Optional.ofNullable(this.bodyLocators.get(columnName));
    }

    public Optional<WebLocatorHolder> getFooterLocator(@NotNull String columnName) {
        return Optional.ofNullable(this.footerLocators.get(columnName));
    }

    @NotNull
    public WebLocatorHolder getRequiredHeaderLocator(@NotNull String columnName) {
        return this.getHeaderLocator(columnName).orElseThrow(() -> LocatorNotFound.exception((String)PageFactoryApiMessages.TABLE_ELEMENT_LOCATOR_FOR_COLUMN_HEADER_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
    }

    @NotNull
    public WebLocatorHolder getRequiredBodyLocator(@NotNull String columnName) {
        return this.getBodyLocator(columnName).orElseThrow(() -> LocatorNotFound.exception((String)PageFactoryApiMessages.TABLE_ELEMENT_LOCATOR_FOR_COLUMN_BODY_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
    }

    @NotNull
    public WebLocatorHolder getRequiredFooterLocator(@NotNull String columnName) {
        return this.getFooterLocator(columnName).orElseThrow(() -> LocatorNotFound.exception((String)PageFactoryApiMessages.TABLE_ELEMENT_LOCATOR_FOR_COLUMN_FOOTER_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element)));
    }

    public Optional<T> getHeaderMappedBlock(@NotNull String columnName) {
        return Optional.ofNullable((WebBlock)this.headers.get(columnName));
    }

    public Optional<T> getBodyMappedBlock(@NotNull String columnName) {
        return Optional.ofNullable((WebBlock)this.body.get(columnName));
    }

    public Optional<T> getFooterMappedBlock(@NotNull String columnName) {
        return Optional.ofNullable((WebBlock)this.footers.get(columnName));
    }

    @NotNull
    public T getRequiredHeaderMappedBlock(@NotNull String columnName) {
        return (T)((WebBlock)this.getHeaderMappedBlock(columnName).orElseThrow(() -> MappedBlockNotFound.exception((String)PageFactoryApiMessages.TABLE_MAPPED_BLOCK_FOR_COLUMN_HEADER_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element))));
    }

    @NotNull
    public T getRequiredBodyMappedBlock(@NotNull String columnName) {
        return (T)((WebBlock)this.getBodyMappedBlock(columnName).orElseThrow(() -> MappedBlockNotFound.exception((String)PageFactoryApiMessages.TABLE_MAPPED_BLOCK_FOR_COLUMN_BODY_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element))));
    }

    @NotNull
    public T getRequiredFooterMappedBlock(@NotNull String columnName) {
        return (T)((WebBlock)this.getFooterMappedBlock(columnName).orElseThrow(() -> MappedBlockNotFound.exception((String)PageFactoryApiMessages.TABLE_MAPPED_BLOCK_FOR_COLUMN_FOOTER_NOT_FOUND.getMessage(new Object[]{columnName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element))));
    }

    public Set<String> getTableColumnNames() {
        return new HashSet<String>(this.columns);
    }

    public Map<String, WebLocatorHolder> getHeaderLocators() {
        return new HashMap<String, WebLocatorHolder>(this.headerLocators);
    }

    public Map<String, WebLocatorHolder> getBodyLocators() {
        return new HashMap<String, WebLocatorHolder>(this.bodyLocators);
    }

    public Map<String, WebLocatorHolder> getFooterLocators() {
        return new HashMap<String, WebLocatorHolder>(this.footerLocators);
    }

    public Map<String, T> getHeaders() {
        return new HashMap<String, T>(this.headers);
    }

    public Map<String, T> getBody() {
        return new HashMap<String, T>(this.body);
    }

    public Map<String, T> getFooters() {
        return new HashMap<String, T>(this.footers);
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        ObjectNode headerLocatorsNode = JsonUtils.createObjectNode();
        this.headerLocators.forEach((key, value) -> headerLocatorsNode.set(key, (JsonNode)value.toJson()));
        rootNode.set("headerLocators", (JsonNode)headerLocatorsNode);
        ObjectNode bodyLocatorsNode = JsonUtils.createObjectNode();
        this.bodyLocators.forEach((key, value) -> bodyLocatorsNode.set(key, (JsonNode)value.toJson()));
        rootNode.set("bodyLocators", (JsonNode)bodyLocatorsNode);
        ObjectNode footerLocatorsNode = JsonUtils.createObjectNode();
        this.headerLocators.forEach((key, value) -> footerLocatorsNode.set(key, (JsonNode)value.toJson()));
        rootNode.set("footerLocators", (JsonNode)footerLocatorsNode);
        ObjectNode headerMappedBlockNode = JsonUtils.createObjectNode();
        this.headers.forEach((key, value) -> headerMappedBlockNode.put(key, value.getClass().getCanonicalName()));
        rootNode.set("headerMappedBlocks", (JsonNode)headerMappedBlockNode);
        ObjectNode bodyMappedBlockNode = JsonUtils.createObjectNode();
        this.body.forEach((key, value) -> bodyMappedBlockNode.put(key, value.getClass().getCanonicalName()));
        rootNode.set("bodyMappedBlocks", (JsonNode)bodyMappedBlockNode);
        ObjectNode footerMappedBlockNode = JsonUtils.createObjectNode();
        this.footers.forEach((key, value) -> footerMappedBlockNode.put(key, value.getClass().getCanonicalName()));
        rootNode.set("footerMappedBlocks", (JsonNode)footerMappedBlockNode);
        return rootNode;
    }
}

