/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.mapping;

import io.perfeccionista.framework.exceptions.MappedBlockNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebListFrame<T extends WebBlock> {
    private final WebChildElement element;
    private final T mappedBlockFrame;

    public WebListFrame(@NotNull WebChildElement element, @Nullable T mappedBlockFrame) {
        this.element = element;
        this.mappedBlockFrame = mappedBlockFrame;
    }

    @NotNull
    public T getMappedBlockFrame() {
        if (Objects.isNull(this.mappedBlockFrame)) {
            throw MappedBlockNotFound.exception((String)PageFactoryApiMessages.MAPPED_BLOCK_IMPLEMENTATION_NOT_FOUND.getMessage(new Object[]{this.element.getClass().getCanonicalName()})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this.element));
        }
        return this.mappedBlockFrame;
    }

    @NotNull
    public Class<T> getMappedBlockClass() {
        return this.mappedBlockFrame.getClass();
    }
}

