/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.locators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebLocatorRegistry {
    protected final Map<String, WebLocatorHolder> locators;

    private WebLocatorRegistry(Map<String, WebLocatorHolder> locators) {
        this.locators = locators;
    }

    public static WebLocatorRegistry empty() {
        return new WebLocatorRegistry(new HashMap<String, WebLocatorHolder>());
    }

    public static WebLocatorRegistry of(Map<String, WebLocatorHolder> locators) {
        return new WebLocatorRegistry(locators);
    }

    public WebLocatorRegistry addLocator(@NotNull String rootLocator, @NotNull WebLocatorHolder locator) {
        this.locators.put(rootLocator, locator);
        return this;
    }

    public Optional<WebLocatorHolder> getOptionalLocator(String locatorName) {
        WebLocatorHolder locatorHolder = this.locators.get(locatorName);
        if (null == locatorHolder) {
            return Optional.empty();
        }
        return Optional.of(locatorHolder.clone());
    }

    public Stream<Map.Entry<String, WebLocatorHolder>> stream() {
        return this.locators.entrySet().stream();
    }

    public void forEach(BiConsumer<String, WebLocatorHolder> consumer) {
        this.locators.forEach(consumer);
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        this.locators.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> rootNode.set((String)entry.getKey(), (JsonNode)((WebLocatorHolder)entry.getValue()).toJson()));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

