/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.locators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorStrategy;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebLocatorHolder {
    protected final String locatorId = UUID.randomUUID().toString();
    protected String locatorComponent;
    protected final WebLocatorStrategy locatorStrategy;
    protected final String locatorValue;
    protected Set<Integer> indexes;
    protected int index;
    protected boolean single;
    protected boolean strictSearch;
    protected boolean onlyWithinParent;
    protected boolean calculateHash;
    protected String expectedHash;
    protected Deque<EndpointHandler<Void>> invokeOnCallHandlers;

    protected WebLocatorHolder(String locatorComponent, WebLocatorStrategy locatorStrategy, String locatorValue) {
        this.locatorComponent = locatorComponent;
        this.locatorStrategy = locatorStrategy;
        this.locatorValue = locatorValue;
        this.indexes = null;
        this.index = -1;
        this.single = true;
        this.strictSearch = true;
        this.onlyWithinParent = true;
        this.calculateHash = false;
        this.expectedHash = null;
        this.invokeOnCallHandlers = new ArrayDeque<EndpointHandler<Void>>();
    }

    public static WebLocatorHolder of(String locatorComponent, WebLocatorStrategy locatorStrategy, String locatorValue) {
        return new WebLocatorHolder(locatorComponent, locatorStrategy, locatorValue);
    }

    public static WebLocatorHolder selfNode(String locatorComponent) {
        return new WebLocatorHolder(locatorComponent, WebLocatorStrategy.SELF_NODE, "");
    }

    public WebLocatorHolder setLocatorComponent(@NotNull String locatorComponent) {
        this.locatorComponent = locatorComponent;
        return this;
    }

    public WebLocatorHolder setIndex(int index) {
        this.index = index;
        return this;
    }

    public WebLocatorHolder setIndexes(@Nullable Collection<Integer> indexes) {
        this.indexes = Objects.isNull(indexes) ? null : new HashSet<Integer>(indexes);
        this.setSingle(false);
        return this;
    }

    public WebLocatorHolder setSingle(boolean single) {
        this.single = single;
        return this;
    }

    public WebLocatorHolder setStrictSearch(boolean strictSearch) {
        this.strictSearch = strictSearch;
        return this;
    }

    public WebLocatorHolder setOnlyWithinParent(boolean onlyWithinParent) {
        this.onlyWithinParent = onlyWithinParent;
        return this;
    }

    public WebLocatorHolder setCalculateHash(boolean calculateHash) {
        this.calculateHash = calculateHash;
        return this;
    }

    public WebLocatorHolder setExpectedHash(@Nullable String expectedHash) {
        this.expectedHash = expectedHash;
        return this;
    }

    public WebLocatorHolder addInvokedOnCallFunction(EndpointHandler<Void> invokeOnCallHandler) {
        this.invokeOnCallHandlers.add(invokeOnCallHandler);
        return this;
    }

    public WebLocatorHolder setInvokedOnCallFunctions(Deque<EndpointHandler<Void>> invokeOnCallHandlers) {
        this.invokeOnCallHandlers = invokeOnCallHandlers;
        return this;
    }

    public String getLocatorId() {
        return this.locatorId;
    }

    public String getLocatorComponent() {
        return this.locatorComponent;
    }

    public WebLocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    public String getLocatorValue() {
        return this.locatorValue;
    }

    @Nullable
    public Set<Integer> getIndexes() {
        return Objects.isNull(this.indexes) ? null : Set.copyOf(this.indexes);
    }

    public boolean isSingle() {
        return this.single;
    }

    public boolean isStrictSearch() {
        return this.strictSearch;
    }

    public boolean isOnlyWithinParent() {
        return this.onlyWithinParent;
    }

    public boolean isCalculateHash() {
        return this.calculateHash;
    }

    public Optional<String> getExpectedHash() {
        return Optional.ofNullable(this.expectedHash);
    }

    public Deque<EndpointHandler<Void>> getInvokeOnCallHandlers() {
        return new ArrayDeque<EndpointHandler<Void>>(this.invokeOnCallHandlers);
    }

    public WebLocatorHolder clone() {
        return new WebLocatorHolder(this.locatorComponent, this.locatorStrategy, this.locatorValue).setIndexes(this.getIndexes()).setSingle(this.single).setStrictSearch(this.strictSearch).setOnlyWithinParent(this.onlyWithinParent).setCalculateHash(this.calculateHash).setExpectedHash(this.expectedHash).setInvokedOnCallFunctions(this.getInvokeOnCallHandlers());
    }

    public ObjectNode toJson() {
        ObjectNode locatorNode = JsonUtils.createObjectNode().put("locatorId", this.locatorId).put("locatorComponent", this.locatorComponent).put("locatorStrategy", this.locatorStrategy.getStrategyName()).put("locatorValue", this.locatorValue).put("single", this.single).put("strictSearch", this.strictSearch).put("onlyWithinParent", this.onlyWithinParent).put("calculateHash", this.calculateHash);
        if (this.getExpectedHash().isPresent()) {
            locatorNode.put("expectedHash", this.expectedHash);
        }
        if (this.single) {
            if (this.index != -1) {
                locatorNode.put("index", this.index);
            }
        } else if (Objects.nonNull(this.indexes)) {
            ArrayNode indexesNode = locatorNode.putArray("indexes");
            this.indexes.stream().sorted().forEachOrdered(arg_0 -> ((ArrayNode)indexesNode).add(arg_0));
        }
        if (!this.invokeOnCallHandlers.isEmpty()) {
            ArrayNode invokeOnCallNode = locatorNode.putArray("invokeOnCallFunctions");
            this.invokeOnCallHandlers.forEach(endpointHandler -> invokeOnCallNode.add(endpointHandler.toJson()));
        }
        return locatorNode;
    }

    public String toString() {
        return JsonUtils.toPrettyJson((JsonNode)this.toJson());
    }

    public String getShortDescription() {
        return "";
    }
}

