/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements.locators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class WebLocatorChain {
    private Deque<WebLocatorHolder> locatorSequence = new ArrayDeque<WebLocatorHolder>();

    public static WebLocatorChain empty() {
        return new WebLocatorChain();
    }

    public static WebLocatorChain of(WebLocatorHolder locator) {
        return new WebLocatorChain().addLastLocator(locator);
    }

    public WebLocatorChain validate() {
        return this;
    }

    public boolean isEmpty() {
        return this.locatorSequence.isEmpty();
    }

    public WebLocatorChain addFirstLocator(@NotNull WebLocatorHolder locator) {
        this.locatorSequence.addFirst(locator);
        return this;
    }

    public WebLocatorChain addLastLocator(@NotNull WebLocatorHolder locator) {
        this.locatorSequence.addLast(locator);
        return this;
    }

    public WebLocatorChain addFirstLocators(@NotNull WebLocatorChain locatorChain) {
        this.addFirstLocators(locatorChain.getAllLocators());
        return this;
    }

    public WebLocatorChain addFirstLocators(@NotNull Collection<WebLocatorHolder> locators) {
        ArrayDeque<WebLocatorHolder> updatedLocatorSequence = new ArrayDeque<WebLocatorHolder>();
        updatedLocatorSequence.addAll(locators);
        updatedLocatorSequence.addAll(this.locatorSequence);
        this.locatorSequence = updatedLocatorSequence;
        return this;
    }

    public WebLocatorChain addLastLocators(@NotNull WebLocatorChain locatorChain) {
        this.locatorSequence.addAll(locatorChain.getAllLocators());
        return this;
    }

    public WebLocatorChain addLastLocators(@NotNull Collection<WebLocatorHolder> locators) {
        this.locatorSequence.addAll(locators);
        return this;
    }

    public WebLocatorChain updateLastLocator(Consumer<WebLocatorHolder> lastLocatorHolderConsumer) {
        lastLocatorHolderConsumer.accept(this.locatorSequence.getLast());
        return this;
    }

    public WebLocatorHolder getFirstLocator() {
        return this.locatorSequence.getFirst();
    }

    public WebLocatorHolder getLastLocator() {
        return this.locatorSequence.getLast();
    }

    public WebLocatorHolder removeLastLocator() {
        return this.locatorSequence.removeLast();
    }

    public Deque<WebLocatorHolder> getAllLocators() {
        return new ArrayDeque<WebLocatorHolder>(this.locatorSequence);
    }

    public ObjectNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        ArrayNode locatorChainNode = rootNode.putArray("locators");
        this.locatorSequence.forEach(webLocatorHolder -> locatorChainNode.add((JsonNode)webLocatorHolder.toJson()));
        return rootNode;
    }
}

