/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.matcher.element.WebPageMatcher;
import io.perfeccionista.framework.name.WebPageIdentifier;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.elements.actions.base.EndpointHandlerRegistry;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorRegistry;
import io.perfeccionista.framework.pagefactory.elements.registry.WebElementRegistry;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WebPageImpl
implements WebPage {
    protected EndpointHandlerRegistry actionRegistry;
    protected WebLocatorRegistry locatorRegistry;
    protected WebElementRegistry elementRegistry;
    protected WebPageIdentifier pageIdentifier;
    protected WebBrowserDispatcher webBrowserDispatcher;
    protected Environment environment;

    @Override
    @NotNull
    public WebBrowserDispatcher getWebBrowserDispatcher() {
        return this.webBrowserDispatcher;
    }

    @Override
    @NotNull
    public WebElementRegistry getElementRegistry() {
        return this.elementRegistry;
    }

    @Override
    @NotNull
    public WebPageIdentifier getPageIdentifier() {
        return this.pageIdentifier;
    }

    @Override
    public WebPage setEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public WebPage setWebBrowserDispatcher(WebBrowserDispatcher webBrowserDispatcher) {
        this.webBrowserDispatcher = webBrowserDispatcher;
        return this;
    }

    @Override
    @NotNull
    public <R> Class<? extends EndpointHandler<R>> getEndpointHandler(@NotNull String actionName, @NotNull Class<R> returnType) {
        return this.actionRegistry.getEndpointHandler(actionName, returnType);
    }

    @Override
    public WebPage should(@NotNull WebPageMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    @NotNull
    public WebLocatorChain getLocatorChainTo(@NotNull String locatorName) {
        if ("ROOT".equals(locatorName)) {
            return this.getLocatorChain();
        }
        Optional<WebLocatorHolder> optionalLocator = this.locatorRegistry.getOptionalLocator(locatorName);
        if (optionalLocator.isPresent()) {
            return this.getLocatorChain().addFirstLocator(optionalLocator.get());
        }
        return this.getLocatorChain();
    }

    @Override
    @NotNull
    public WebLocatorChain getLocatorChain() {
        Optional<WebLocatorHolder> optionalPageRootLocator = this.locatorRegistry.getOptionalLocator("ROOT");
        if (optionalPageRootLocator.isPresent()) {
            return WebLocatorChain.empty().addFirstLocator(optionalPageRootLocator.get());
        }
        return WebLocatorChain.empty();
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        rootNode.put("elementClass", this.getClass().getCanonicalName());
        rootNode.set("pageIdentifier", this.pageIdentifier.toJson());
        rootNode.set("locators", this.locatorRegistry.toJson());
        rootNode.set("elements", this.elementRegistry.toJson());
        rootNode.set("endpointHandlers", this.actionRegistry.toJson());
        return rootNode;
    }
}

