/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.LocatorNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.name.WebElementIdentifier;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.elements.actions.base.EndpointHandlerRegistry;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.base.WebParentHolder;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorChain;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorHolder;
import io.perfeccionista.framework.pagefactory.elements.locators.WebLocatorRegistry;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.handler.EndpointHandler;
import io.perfeccionista.framework.pagefactory.operation.type.WebActionOperationType;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class AbstractWebChildElementBase
implements WebChildElementBase {
    protected WebParentHolder parentHolder;
    protected WebLocatorRegistry locatorRegistry;
    protected EndpointHandlerRegistry actionRegistry;
    protected WebElementIdentifier elementIdentifier;

    @NotNull
    public Environment getEnvironment() {
        return this.parentHolder.getParent().getEnvironment();
    }

    @Override
    @NotNull
    public WebBrowserDispatcher getWebBrowserDispatcher() {
        return this.parentHolder.getParent().getWebBrowserDispatcher();
    }

    @Override
    @NotNull
    public WebLocatorHolder getRequiredLocator(@NotNull String componentName) {
        return this.locatorRegistry.getOptionalLocator(componentName).orElseThrow(() -> LocatorNotFound.exception((String)PageFactoryApiMessages.ELEMENT_LOCATOR_NOT_FOUND.getMessage(new Object[]{componentName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this)));
    }

    @Override
    public Optional<WebLocatorHolder> getOptionalLocator(@NotNull String componentName) {
        return this.locatorRegistry.getOptionalLocator(componentName);
    }

    @Override
    @NotNull
    public WebParentHolder getParentHolder() {
        return this.parentHolder;
    }

    @Override
    @NotNull
    public WebLocatorChain getLocatorChainTo(@NotNull String locatorName) {
        if ("ROOT".equals(locatorName)) {
            return this.getLocatorChain();
        }
        Optional<WebLocatorHolder> optionalLocator = this.locatorRegistry.getOptionalLocator(locatorName);
        if (optionalLocator.isPresent()) {
            return this.getLocatorChain().addLastLocator(optionalLocator.get());
        }
        return this.getLocatorChain();
    }

    @Override
    @NotNull
    public WebLocatorChain getLocatorChain() {
        return this.parentHolder.getLocatorChain().addLastLocator(this.getRequiredLocator("ROOT"));
    }

    @Override
    @NotNull
    public WebElementIdentifier getElementIdentifier() {
        return this.elementIdentifier;
    }

    @NotNull
    public <T> Class<? extends EndpointHandler<T>> getEndpointHandler(@NotNull String actionName, @NotNull Class<T> returnType) {
        return this.actionRegistry.getEndpointHandler(actionName, returnType);
    }

    @Override
    public WebChildElementBase executeAction(@NotNull String name, Object ... args) {
        WebActionOperationType operationType = WebActionOperationType.of(this, name, args);
        CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeAction());
        return this;
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode();
        rootNode.set("elementIdentifier", this.elementIdentifier.toJson());
        rootNode.put("elementClass", this.getClass().getCanonicalName()).put("parent", this.parentHolder.getParent().getClass().getCanonicalName());
        rootNode.set("locators", this.locatorRegistry.toJson());
        rootNode.set("actions", this.actionRegistry.toJson());
        return rootNode;
    }
}

