/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.elements;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.color.Color;
import io.perfeccionista.framework.exceptions.ElementStateNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.element.WebChildElementMatcher;
import io.perfeccionista.framework.matcher.methods.WebComponentAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebElementPropertyAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebElementStateAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebGetColorAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebGetElementBoundsAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebGetScreenshotAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebIsDisplayedAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebIsInFocusAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebIsOnTheScreenAvailableMatcher;
import io.perfeccionista.framework.matcher.methods.WebIsPresentAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.AbstractWebChildElementBase;
import io.perfeccionista.framework.pagefactory.elements.ElementBounds;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyHolder;
import io.perfeccionista.framework.pagefactory.elements.properties.base.WebElementPropertyRegistry;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateRegistry;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsDisplayedOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementIsPresentOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationHandler;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetColorOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetElementBoundsOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsComponentDisplayedOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsComponentPresentOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsDisplayedOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsInFocusOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsOnTheScreenOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetIsPresentOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetScreenshotOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebGetStringAttributeValueOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebHoverToOperationType;
import io.perfeccionista.framework.pagefactory.operation.type.WebScrollToOperationType;
import io.perfeccionista.framework.screenshots.Screenshot;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractWebChildElement
extends AbstractWebChildElementBase
implements WebChildElement {
    protected WebElementStateRegistry stateRegistry;
    protected WebElementPropertyRegistry propertyRegistry;

    @Override
    public WebChildElement executeAction(@NotNull String name, Object ... args) {
        super.executeAction(name, args);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebChildElementMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebGetColorAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebGetElementBoundsAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebGetScreenshotAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebIsDisplayedAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebIsInFocusAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebIsOnTheScreenAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebIsPresentAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebComponentAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebElementPropertyAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    public WebChildElement should(@NotNull WebElementStateAvailableMatcher matcher) {
        matcher.check(this);
        return this;
    }

    @Override
    @NotNull
    public Color getColor(@NotNull String cssProperty) {
        WebGetColorOperationType operationType = WebGetColorOperationType.of(this, "ROOT", cssProperty);
        return (Color)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeGetter());
    }

    @Override
    @NotNull
    public Color getColor(@NotNull String componentName, @NotNull String cssProperty) {
        WebGetColorOperationType operationType = WebGetColorOperationType.of(this, componentName, cssProperty);
        return (Color)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, componentName).executeGetter());
    }

    @Override
    @NotNull
    public ElementBounds getElementBounds() {
        WebGetElementBoundsOperationType operationType = WebGetElementBoundsOperationType.of(this, "ROOT");
        return (ElementBounds)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeGetter());
    }

    @Override
    @NotNull
    public ElementBounds getElementBounds(@NotNull String componentName) {
        WebGetElementBoundsOperationType operationType = WebGetElementBoundsOperationType.of(this, componentName);
        return (ElementBounds)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, componentName).executeGetter());
    }

    @Override
    @NotNull
    public Screenshot getScreenshot() {
        WebGetScreenshotOperationType operationType = WebGetScreenshotOperationType.of(this, "ROOT");
        return (Screenshot)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeGetter());
    }

    @Override
    @NotNull
    public Screenshot getScreenshot(@NotNull String componentName) {
        WebGetScreenshotOperationType operationType = WebGetScreenshotOperationType.of(this, componentName);
        return (Screenshot)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, componentName).executeGetter());
    }

    @Override
    public WebChildElement hoverTo(boolean withOutOfBounds) {
        WebHoverToOperationType operationType = WebHoverToOperationType.of(this, withOutOfBounds);
        CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, "HOVER").executeAction());
        return this;
    }

    @Override
    public boolean isDisplayed() {
        WebGetIsDisplayedOperationType operationType = WebGetIsDisplayedOperationType.of(this);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementIsDisplayedOperationHandler.of(this, operationType, "DISPLAYED").executeGetter());
    }

    @Override
    public boolean isInFocus() {
        WebGetIsInFocusOperationType operationType = WebGetIsInFocusOperationType.of(this);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, "FOCUS").executeGetter());
    }

    @Override
    public boolean isOnTheScreen() {
        WebGetIsOnTheScreenOperationType operationType = WebGetIsOnTheScreenOperationType.of(this);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeGetter());
    }

    @Override
    public boolean isPresent() {
        WebGetIsPresentOperationType operationType = WebGetIsPresentOperationType.of(this);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementIsPresentOperationHandler.of(this, operationType, "PRESENTED").executeGetter());
    }

    @Override
    public WebChildElement scrollTo() {
        WebScrollToOperationType operationType = WebScrollToOperationType.of(this);
        CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType).executeAction());
        return this;
    }

    @Override
    public boolean isComponentDisplayed(@NotNull String componentName) {
        WebGetIsComponentDisplayedOperationType operationType = WebGetIsComponentDisplayedOperationType.of(this, componentName);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, componentName).executeGetter());
    }

    @Override
    public boolean isComponentPresent(@NotNull String componentName) {
        WebGetIsComponentPresentOperationType operationType = WebGetIsComponentPresentOperationType.of(this, componentName);
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, componentName).executeGetter());
    }

    @Override
    public Optional<WebElementPropertyHolder> getProperty(String propertyName) {
        return this.propertyRegistry.getProperty(propertyName);
    }

    @Override
    @Nullable
    public String getPropertyValue(@NotNull String propertyName) {
        Optional<WebElementPropertyHolder> optionalPropertyHolder = this.getProperty(propertyName);
        if (optionalPropertyHolder.isPresent()) {
            WebElementPropertyHolder propertyHolder = optionalPropertyHolder.get();
            return (String)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"GetPropertyValue", (Object[])new Object[]{this, propertyHolder}), () -> {
                WebElementOperation<String> operation = propertyHolder.getOperation(this);
                return this.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
                    throw exceptionMapper.mapElementException(this, (RuntimeException)originalException);
                }).getResult();
            });
        }
        WebGetStringAttributeValueOperationType operationType = WebGetStringAttributeValueOperationType.of(this, propertyName);
        return (String)CheckInvocationWrapper.runCheck((InvocationInfo)operationType.getInvocationName(), () -> WebElementOperationHandler.of(this, operationType, propertyName).executeGetter());
    }

    @Override
    public Optional<WebElementStateHolder> getState(String stateName) {
        return this.stateRegistry.getState(stateName);
    }

    @Override
    public boolean hasState(@NotNull String stateName) {
        WebElementStateHolder stateHolder = this.getState(stateName).orElseThrow(() -> ElementStateNotFound.exception((String)PageFactoryApiMessages.ELEMENT_STATE_NOT_FOUND.getMessage(new Object[]{stateName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(this)));
        return (Boolean)CheckInvocationWrapper.runCheck((InvocationInfo)InvocationInfo.getterInvocation((String)"HasState", (Object[])new Object[]{this, stateHolder}), () -> {
            WebElementOperation<Boolean> operation = stateHolder.getOperation(this);
            WebElementOperationResult<Boolean> operationResult = this.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
                throw exceptionMapper.mapElementException(this, (RuntimeException)originalException);
            });
            if (operationResult.hasResult()) {
                return operationResult.getNotNullResult();
            }
            return false;
        });
    }

    @Override
    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = (ObjectNode)super.toJson();
        rootNode.set("properties", this.propertyRegistry.toJson());
        rootNode.set("states", this.stateRegistry.toJson());
        return rootNode;
    }
}

