/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher.cookies;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.CookieValidation;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.utils.JsonUtils;
import io.perfeccionista.framework.utils.StringUtils;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class Cookie
implements JsonSerializable {
    private final String name;
    private final String value;
    private String domain = null;
    private String path = null;
    private LocalDateTime expirationDate = null;
    private boolean isSecure = false;
    private boolean isHttpOnly = false;

    private Cookie(@NotNull String name, @NotNull String value) {
        this.name = Cookie.validateName(name);
        this.value = value;
        this.path = this.validatePath(null);
    }

    public static Cookie of(@NotNull String name, @NotNull String value) {
        return new Cookie(Cookie.validateName(name), value);
    }

    public Cookie setDomain(@Nullable String domain) {
        this.domain = this.validateDomain(domain);
        return this;
    }

    public Cookie setPath(@Nullable String path) {
        this.path = this.validatePath(path);
        return this;
    }

    public Cookie setExpirationDate(@Nullable LocalDateTime expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    public Cookie setSecure(boolean secure) {
        this.isSecure = secure;
        return this;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.isHttpOnly = httpOnly;
        return this;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    protected static String validateName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw CookieValidation.exception(PageFactoryWebApiMessages.COOKIES_NAME_EMPTY.getMessage(new Object[0]));
        }
        if (name.contains(";") || name.contains(" ") || name.contains("=") || name.contains(",")) {
            throw CookieValidation.exception(PageFactoryWebApiMessages.COOKIES_NAME_INCORRECT.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Cookie's name", (String)name));
        }
        return name;
    }

    protected String validateDomain(String domain) {
        if (Objects.isNull(domain)) {
            return null;
        }
        String validatableDomain = domain.split(":")[0];
        if (validatableDomain.contains(":")) {
            throw CookieValidation.exception(PageFactoryWebApiMessages.COOKIES_DOMAIN_CONTAINS_PORT.getMessage(new Object[0])).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Cookie's domain", (String)validatableDomain));
        }
        return validatableDomain;
    }

    protected String validatePath(String path) {
        return StringUtils.isBlank((String)path) ? "/" : path;
    }

    @NotNull
    public JsonNode toJson() {
        return JsonUtils.createObjectNode().put("name", this.name).put("value", this.value).put("domain", this.domain).put("path", this.path).put("expirationDate", Objects.isNull(this.expirationDate) ? "null" : this.expirationDate.toString()).put("isSecure", this.isSecure).put("isHttpOnly", this.isHttpOnly);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (!this.name.equals(cookie.name)) {
            return false;
        }
        return this.value.equals(cookie.value);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

