/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory.dispatcher;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.ExceptionMapperNotFound;
import io.perfeccionista.framework.exceptions.IncorrectServiceConfiguration;
import io.perfeccionista.framework.exceptions.WebBrowserConfigurationNotFound;
import io.perfeccionista.framework.exceptions.WebBrowserDispatcherNotStarted;
import io.perfeccionista.framework.exceptions.mapper.WebExceptionMapper;
import io.perfeccionista.framework.exceptions.messages.EnvironmentMessages;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.exceptions.messages.UtilsMessages;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserDispatcher;
import io.perfeccionista.framework.pagefactory.dispatcher.WebBrowserServiceConfiguration;
import io.perfeccionista.framework.service.Service;
import io.perfeccionista.framework.service.ServiceConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebBrowserService
implements Service {
    protected Environment environment;
    protected WebBrowserServiceConfiguration configuration;
    protected Set<WebBrowserDispatcher> webBrowserDispatchers = new HashSet<WebBrowserDispatcher>();
    protected Map<String, WebBrowserDispatcher> webBrowserDispatchersByName = new HashMap<String, WebBrowserDispatcher>();
    protected WebBrowserDispatcher activeWebBrowserDispatcher = null;

    public void init(@NotNull Environment environment, @NotNull ServiceConfiguration configuration) {
        this.environment = environment;
        this.configuration = this.validate(configuration);
    }

    public void afterTest() {
        if (this.configuration.isCloseWebBrowsersAfterTest()) {
            this.closeAll();
        }
    }

    @NotNull
    public WebBrowserDispatcher createDispatcher(@NotNull String webBrowserConfigurationName) {
        WebBrowserDispatcher webBrowserDispatcher = Optional.ofNullable(this.configuration.getWebBrowserConfigurations().get(webBrowserConfigurationName)).orElseThrow(() -> WebBrowserConfigurationNotFound.exception(PageFactoryWebApiMessages.WEB_BROWSER_CONFIGURATION_NOT_FOUND.getMessage(new Object[]{webBrowserConfigurationName}))).get();
        this.webBrowserDispatchers.add(webBrowserDispatcher);
        this.activeWebBrowserDispatcher = webBrowserDispatcher;
        return webBrowserDispatcher;
    }

    @NotNull
    public WebBrowserDispatcher createDispatcher(@NotNull String webBrowserConfigurationName, @NotNull String webBrowserDispatcherName) {
        WebBrowserDispatcher webBrowserDispatcher = Optional.ofNullable(this.configuration.getWebBrowserConfigurations().get(webBrowserConfigurationName)).orElseThrow(() -> WebBrowserConfigurationNotFound.exception(PageFactoryWebApiMessages.WEB_BROWSER_CONFIGURATION_NOT_FOUND.getMessage(new Object[]{webBrowserConfigurationName}))).get();
        this.webBrowserDispatchersByName.put(webBrowserDispatcherName, webBrowserDispatcher);
        this.activeWebBrowserDispatcher = webBrowserDispatcher;
        return webBrowserDispatcher;
    }

    public boolean isActiveDispatcherRunning() {
        return Objects.nonNull(this.activeWebBrowserDispatcher);
    }

    @NotNull
    public WebBrowserDispatcher getActiveDispatcher() {
        return Optional.ofNullable(this.activeWebBrowserDispatcher).orElseThrow(() -> WebBrowserDispatcherNotStarted.exception(PageFactoryWebApiMessages.NO_ACTIVE_WEB_BROWSER_DISPATCHER_FOUND.getMessage(new Object[0])));
    }

    @NotNull
    public WebBrowserDispatcher setActiveDispatcher(@NotNull String webBrowserDispatcherName) {
        this.activeWebBrowserDispatcher = this.getDispatcherByName(webBrowserDispatcherName);
        return this.activeWebBrowserDispatcher;
    }

    @NotNull
    public WebBrowserDispatcher getDispatcherByName(@NotNull String webBrowserDispatcherName) {
        return Optional.ofNullable(this.webBrowserDispatchersByName.get(webBrowserDispatcherName)).orElseThrow(() -> WebBrowserDispatcherNotStarted.exception(PageFactoryWebApiMessages.NO_ACTIVE_WEB_BROWSER_DISPATCHER_WITH_NAME_FOUND.getMessage(new Object[]{webBrowserDispatcherName})));
    }

    public WebBrowserService closeAll() {
        this.webBrowserDispatchersByName.forEach((name, webBrowserDispatcher) -> webBrowserDispatcher.close());
        this.webBrowserDispatchers.forEach(WebBrowserDispatcher::close);
        this.activeWebBrowserDispatcher = null;
        return this;
    }

    @NotNull
    public WebExceptionMapper getExceptionMapper(@NotNull Class<? extends WebExceptionMapper> exceptionMapperClass) {
        return Optional.ofNullable(this.configuration.getExceptionMappers().get(exceptionMapperClass)).orElseThrow(() -> ExceptionMapperNotFound.exception((String)UtilsMessages.EXCEPTION_MAPPER_FOR_CLASS_NOT_FOUND.getMessage(new Object[]{exceptionMapperClass.getCanonicalName()})));
    }

    protected WebBrowserServiceConfiguration validate(ServiceConfiguration configuration) {
        if (configuration instanceof WebBrowserServiceConfiguration) {
            return (WebBrowserServiceConfiguration)configuration;
        }
        throw IncorrectServiceConfiguration.exception((String)EnvironmentMessages.SERVICE_CONFIGURATION_NOT_VALID.getMessage(new Object[]{configuration.getClass().getCanonicalName(), this.getClass().getCanonicalName()}));
    }
}

