/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.pagefactory;

import io.perfeccionista.framework.Environment;
import io.perfeccionista.framework.exceptions.IncorrectServiceConfiguration;
import io.perfeccionista.framework.exceptions.PageNotFound;
import io.perfeccionista.framework.exceptions.RegisterDuplicate;
import io.perfeccionista.framework.exceptions.messages.EnvironmentMessages;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.name.Name;
import io.perfeccionista.framework.pagefactory.WebPageServiceConfiguration;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.pagefactory.factory.WebPageFactory;
import io.perfeccionista.framework.service.Service;
import io.perfeccionista.framework.service.ServiceConfiguration;
import io.perfeccionista.framework.utils.AnnotationUtils;
import io.perfeccionista.framework.utils.CastUtils;
import io.perfeccionista.framework.utils.ReflectionUtilsForClasses;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebPageService
implements Service {
    private final Map<Class<? extends WebPage>, WebPage> pageInstances = new HashMap<Class<? extends WebPage>, WebPage>();
    private final Map<String, Class<? extends WebPage>> pageClassesByName = new HashMap<String, Class<? extends WebPage>>();
    private final Set<Class<? extends WebPage>> availablePageClasses = new HashSet<Class<? extends WebPage>>();
    private WebPageServiceConfiguration configuration;
    private WebPageFactory webPageFactory;
    private Environment environment;

    public void init(@NotNull Environment environment, @NotNull ServiceConfiguration configuration) {
        this.environment = environment;
        this.configuration = this.validate(configuration);
        ReflectionUtilsForClasses.findAllClasses(this.configuration.getPageObjectPackages(), WebPage.class).forEach(webPageClass -> {
            this.availablePageClasses.add((Class<? extends WebPage>)webPageClass);
            List names = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)webPageClass, Name.class);
            names.stream().map(Name::value).forEach(name -> {
                if (this.pageClassesByName.containsKey(name)) {
                    throw RegisterDuplicate.exception((String)PageFactoryApiMessages.PAGE_NAME_DUPLICATE.getMessage(new Object[]{name, webPageClass, this.pageClassesByName.get(name)}));
                }
                this.pageClassesByName.put((String)name, (Class<? extends WebPage>)webPageClass);
            });
        });
    }

    public WebPageServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public WebPageFactory getWebPageFactory() {
        if (Objects.isNull(this.webPageFactory)) {
            this.webPageFactory = new WebPageFactory(this.configuration.getElementsPreferences());
        }
        return this.webPageFactory;
    }

    @NotNull
    public <T extends WebPage> T getPageInstanceByClass(@NotNull Class<T> pageClass) {
        if (!this.availablePageClasses.contains(pageClass)) {
            throw PageNotFound.exception((String)PageFactoryApiMessages.PAGE_NOT_FOUND_BY_CLASS.getMessage(new Object[]{pageClass.getCanonicalName()}));
        }
        if (!this.pageInstances.containsKey(pageClass)) {
            this.createInstance(pageClass);
        }
        return (T)((WebPage)CastUtils.castObject((Object)this.pageInstances.get(pageClass), pageClass));
    }

    @NotNull
    public WebPage getPageInstanceByName(@NotNull String pageName) {
        Class<? extends WebPage> pageClass = this.pageClassesByName.get(pageName);
        if (pageClass == null) {
            throw PageNotFound.exception((String)PageFactoryApiMessages.PAGE_NOT_FOUND_BY_NAME.getMessage(new Object[]{pageName}));
        }
        if (!this.pageInstances.containsKey(pageClass)) {
            this.createInstance(pageClass);
        }
        return this.pageInstances.get(pageClass);
    }

    protected WebPageServiceConfiguration validate(ServiceConfiguration configuration) {
        if (configuration instanceof WebPageServiceConfiguration) {
            return (WebPageServiceConfiguration)configuration;
        }
        throw IncorrectServiceConfiguration.exception((String)EnvironmentMessages.SERVICE_CONFIGURATION_NOT_VALID.getMessage(new Object[]{configuration.getClass().getCanonicalName(), this.getClass().getCanonicalName()}));
    }

    protected void createInstance(@NotNull Class<? extends WebPage> pageClass) {
        WebPage webPageInstance = this.getWebPageFactory().createWebPage(pageClass);
        this.pageInstances.put(pageClass, webPageInstance);
    }
}

