/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.name;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.json.JsonSerializable;
import io.perfeccionista.framework.pagefactory.elements.WebPage;
import io.perfeccionista.framework.utils.JsonUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class WebPageIdentifier
implements JsonSerializable {
    private final Set<String> names;
    private final Set<String> urls;
    private String lastUsedName = null;

    private WebPageIdentifier(Set<String> names, Set<String> urls) {
        this.names = names;
        this.urls = urls;
    }

    public static WebPageIdentifier of(Set<String> names, Set<String> urls) {
        return new WebPageIdentifier(names, urls);
    }

    public static WebPageIdentifier of(Class<? extends WebPage> pageClass) {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> urls = new HashSet<String>();
        return new WebPageIdentifier(names, urls);
    }

    public void setLastUsedName(String lastUsedName) {
        this.lastUsedName = lastUsedName;
    }

    public String getLastUsedName() {
        return this.lastUsedName == null ? this.names.stream().findFirst().orElse("undefined") : this.lastUsedName;
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public Set<String> names() {
        return Set.copyOf(this.names);
    }

    public Stream<String> namesStream() {
        return this.names.stream();
    }

    public void forEachName(Consumer<String> consumer) {
        this.names.forEach(consumer);
    }

    public Set<String> urls() {
        return Set.copyOf(this.urls);
    }

    public Stream<String> urlsStream() {
        return this.urls.stream();
    }

    public void forEachUrl(Consumer<String> consumer) {
        this.urls.forEach(consumer);
    }

    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("lastUsedName", this.lastUsedName);
        ArrayNode namesNode = rootNode.putArray("names");
        this.forEachName(arg_0 -> ((ArrayNode)namesNode).add(arg_0));
        ArrayNode urlsNode = rootNode.putArray("urls");
        this.forEachUrl(arg_0 -> ((ArrayNode)urlsNode).add(arg_0));
        return rootNode;
    }
}

