/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.name;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.perfeccionista.framework.exceptions.ElementNameNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.name.WebElementIdentifier;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.utils.JsonUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class WebChildElementIdentifier
implements WebElementIdentifier {
    private final Method elementMethod;
    private final Map<String, Boolean> names;
    private String lastUsedName = null;

    private WebChildElementIdentifier(Map<String, Boolean> names, Method elementMethod) {
        this.names = names;
        this.elementMethod = elementMethod;
    }

    public static WebChildElementIdentifier of(@NotNull Map<String, Boolean> names, @NotNull Method elementMethod) {
        return new WebChildElementIdentifier(names, elementMethod);
    }

    @Override
    @NotNull
    public String getLastUsedName() {
        return this.lastUsedName == null ? this.elementMethod.getName() : this.lastUsedName;
    }

    @Override
    @NotNull
    public Method getElementMethod() {
        return this.elementMethod;
    }

    @Override
    @NotNull
    public Class<? extends WebChildElement> getElementType() {
        return this.elementMethod.getReturnType();
    }

    @Override
    public boolean containsName(@NotNull String name) {
        return this.names.containsKey(name);
    }

    @Override
    public boolean isNameDeprecated(@NotNull String name) {
        if (!this.names.containsKey(name)) {
            throw ElementNameNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NAME_NOT_FOUND.getMessage(new Object[]{name}));
        }
        return this.names.get(name);
    }

    @Override
    public Set<String> names() {
        return Set.copyOf(this.names.keySet());
    }

    @Override
    public Stream<String> namesStream() {
        return this.names().stream();
    }

    @Override
    public WebChildElementIdentifier forEachName(@NotNull Consumer<String> consumer) {
        this.names().forEach(consumer);
        return this;
    }

    @Override
    public WebChildElementIdentifier setLastUsedName(@NotNull String lastUsedName) {
        this.lastUsedName = lastUsedName;
        return this;
    }

    @Override
    public WebChildElementIdentifier addElementsByMethodName(@NotNull Map<String, WebChildElement> elementsByMethodName, @NotNull WebChildElement webChildElement) {
        elementsByMethodName.put(this.elementMethod.getName(), webChildElement);
        return this;
    }

    @Override
    public WebChildElementIdentifier addElementsByMethod(@NotNull Map<Method, WebChildElement> elementsByMethod, @NotNull WebChildElement webChildElement) {
        elementsByMethod.put(this.elementMethod, webChildElement);
        return this;
    }

    @Override
    public WebChildElementIdentifier addElementsByName(@NotNull Map<String, WebChildElement> elementsByName, @NotNull WebChildElement webChildElement) {
        this.names.forEach((name, deprecated) -> elementsByName.put((String)name, webChildElement));
        return this;
    }

    @NotNull
    public JsonNode toJson() {
        ObjectNode rootNode = JsonUtils.createObjectNode().put("elementMethod", this.elementMethod.toString()).put("lastUsedName", this.lastUsedName);
        ArrayNode namesNode = rootNode.putArray("names");
        this.forEachName(arg_0 -> ((ArrayNode)namesNode).add(arg_0));
        return rootNode;
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

