/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.name;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.ElementNameNotFound;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.name.WebElementIdentifier;
import io.perfeccionista.framework.pagefactory.elements.WebBlock;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.utils.JsonUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MappedWebBlockIdentifier
implements WebElementIdentifier {
    private final Class<? extends WebBlock> mappedBlockClass;
    private final Map<String, Boolean> names;
    private String lastUsedName = null;

    private MappedWebBlockIdentifier(Class<? extends WebBlock> mappedBlockClass, Map<String, Boolean> names) {
        this.mappedBlockClass = mappedBlockClass;
        this.names = names;
    }

    public static MappedWebBlockIdentifier of(@NotNull Class<? extends WebBlock> mappedBlockClass) {
        return new MappedWebBlockIdentifier(mappedBlockClass, new HashMap<String, Boolean>());
    }

    public static MappedWebBlockIdentifier of(@NotNull Class<? extends WebBlock> mappedBlockClass, @NotNull Map<String, Boolean> names) {
        return new MappedWebBlockIdentifier(mappedBlockClass, names);
    }

    @Override
    @NotNull
    public String getLastUsedName() {
        if (Objects.isNull(this.lastUsedName)) {
            return this.mappedBlockClass.getCanonicalName();
        }
        return this.lastUsedName;
    }

    @Override
    @NotNull
    public Method getElementMethod() {
        throw new UnsupportedOperationException("MappedBlock can't be called by method because it's declared by annotation");
    }

    @NotNull
    public Class<? extends WebBlock> getElementType() {
        return this.mappedBlockClass;
    }

    @Override
    public boolean containsName(@NotNull String name) {
        return this.names.containsKey(name);
    }

    @Override
    public boolean isNameDeprecated(@NotNull String name) {
        if (!this.names.containsKey(name)) {
            throw ElementNameNotFound.exception((String)PageFactoryApiMessages.ELEMENT_NAME_NOT_FOUND.getMessage(new Object[]{name}));
        }
        return this.names.get(name);
    }

    @Override
    public Set<String> names() {
        return this.names.keySet();
    }

    @Override
    public Stream<String> namesStream() {
        return this.names().stream();
    }

    @Override
    public MappedWebBlockIdentifier forEachName(@NotNull Consumer<String> consumer) {
        this.names().forEach(consumer);
        return this;
    }

    @Override
    public MappedWebBlockIdentifier setLastUsedName(@NotNull String lastUsedName) {
        this.lastUsedName = lastUsedName;
        return this;
    }

    @Override
    public MappedWebBlockIdentifier addElementsByMethodName(@NotNull Map<String, WebChildElement> elementsByMethodName, @NotNull WebChildElement webChildElement) {
        return this;
    }

    @Override
    public MappedWebBlockIdentifier addElementsByMethod(@NotNull Map<Method, WebChildElement> elementsByMethod, @NotNull WebChildElement webChildElement) {
        return this;
    }

    @Override
    public MappedWebBlockIdentifier addElementsByName(@NotNull Map<String, WebChildElement> elementsByName, @NotNull WebChildElement webChildElement) {
        this.names.forEach((name, deprecated) -> elementsByName.put((String)name, webChildElement));
        return this;
    }

    @NotNull
    public JsonNode toJson() {
        return JsonUtils.createObjectNode();
    }

    public String toString() {
        return this.toJson().toPrettyString();
    }
}

