/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.value.string.StringValue;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveStringValueResultMatcher
implements WebMultipleIndexedResultMatcher<String> {
    private final StringValue expectedResult;

    public WebShouldHaveStringValueResultMatcher(@NotNull StringValue expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<String, ? extends WebChildElement> result) {
        InvocationInfo invocationName = InvocationInfo.assertInvocation((String)"ShouldHaveExpectedResult", (Object[])new Object[]{this});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            AtomicBoolean match = new AtomicBoolean(true);
            Map results = result.getResults();
            results.forEach((index, value) -> {
                if (!this.expectedResult.check(value)) {
                    match.set(false);
                }
            });
            if (!match.get()) {
                throw ResultVerification.assertionError((String)PageFactoryWebApiMessages.FILTERED_ELEMENT_DOES_NOT_CONTAIN_EXPECTED_RESULT.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedResult)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)"Results", new HashSet(results.values())));
            }
        });
    }
}

