/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.WebResultSetNotSorted;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveSortedResultMatcher<T>
implements WebMultipleIndexedResultMatcher<T> {
    private final Comparator<T> comparator;

    public WebShouldHaveSortedResultMatcher(@NotNull Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<T, ? extends WebChildElement> result) {
        InvocationInfo invocationName = InvocationInfo.assertInvocation((String)"ShouldBeSorted", (Object[])new Object[]{this});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            AtomicBoolean comparisonResult = new AtomicBoolean(true);
            HashMap<String, Integer> detailComparisonResult = new HashMap<String, Integer>();
            result.getResults().entrySet().stream().sorted(Map.Entry.comparingByKey()).reduce((entry1, entry2) -> {
                int pairComparisonResult = this.comparator.compare(entry1.getValue(), entry2.getValue());
                if (pairComparisonResult > 0) {
                    comparisonResult.set(false);
                }
                String indexPair = String.format("Compare indexes %10d and %10d", entry1.getKey(), entry2.getKey());
                detailComparisonResult.put(indexPair, pairComparisonResult);
                return entry2;
            });
            if (!comparisonResult.get()) {
                throw WebResultSetNotSorted.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_IS_NOT_SORTED.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Comparison result", (String)this.comparisonResultsToString(detailComparisonResult)));
            }
        });
    }

    @NotNull
    private String comparisonResultsToString(@NotNull Map<String, Integer> detailComparisonResults) {
        StringBuilder sb = new StringBuilder("Comparison result :\n");
        detailComparisonResults.forEach((indexPair, indexPairComparisonResult) -> sb.append((String)indexPair).append(" -> ").append(indexPairComparisonResult).append("\n"));
        return sb.toString();
    }
}

