/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.WebElementSize;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.SizeAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebIndexesMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import io.perfeccionista.framework.value.number.NumberValue;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveSizeNumberValueMatcher
implements WebIndexesMatcher {
    private final NumberValue<Integer> expectedValue;
    private final boolean positive;

    public WebShouldHaveSizeNumberValueMatcher(@NotNull NumberValue<Integer> expectedValue, boolean positive) {
        this.expectedValue = expectedValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<Integer, ? extends WebChildElement> result) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveSizeValue", (Object[])new Object[]{this, this.expectedValue}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveSizeValue", (Object[])new Object[]{this, this.expectedValue});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            int actualSize = result.getSize();
            if (this.positive) {
                this.shouldHaveSize(element, actualSize);
            } else {
                this.shouldNotHaveSize(element, actualSize);
            }
        });
    }

    protected void shouldHaveSize(WebChildElement element, Integer actualSize) {
        if (!this.expectedValue.check((Object)actualSize)) {
            throw WebElementSize.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_SIZE_NOT_MATCH.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)SizeAttachmentEntry.of(this.expectedValue));
        }
    }

    protected void shouldNotHaveSize(WebChildElement element, Integer actualSize) {
        if (this.expectedValue.check((Object)actualSize)) {
            throw WebElementSize.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_SIZE_MATCH.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)SizeAttachmentEntry.of(this.expectedValue));
        }
    }
}

