/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.WebElementSize;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.SizeAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebIndexesMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveSizeNumberMatcher
implements WebIndexesMatcher {
    private final Integer expectedSize;
    private final boolean positive;

    public WebShouldHaveSizeNumberMatcher(int expectedSize, boolean positive) {
        this.expectedSize = expectedSize;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<Integer, ? extends WebChildElement> result) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveSize", (Object[])new Object[]{this, this.expectedSize}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveSize", (Object[])new Object[]{this, this.expectedSize});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            int actualSize = result.getSize();
            if (this.positive) {
                this.shouldHaveSize(element, actualSize);
            } else {
                this.shouldNotHaveSize(element, actualSize);
            }
        });
    }

    protected void shouldHaveSize(WebChildElement element, Integer actualSize) {
        if (!this.expectedSize.equals(actualSize)) {
            throw WebElementSize.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_SIZE_NOT_MATCH.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)SizeAttachmentEntry.of((int)this.expectedSize, (int)actualSize));
        }
    }

    protected void shouldNotHaveSize(WebChildElement element, Integer actualSize) {
        if (this.expectedSize.equals(actualSize)) {
            throw WebElementSize.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_SIZE_MATCH.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)SizeAttachmentEntry.of((int)this.expectedSize, (int)actualSize));
        }
    }
}

