/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.ResultVerification;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebMultipleIndexedResultMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveResultMatcher<T>
implements WebMultipleIndexedResultMatcher<T> {
    private final T expectedResult;

    public WebShouldHaveResultMatcher(@NotNull T expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<T, ? extends WebChildElement> result) {
        InvocationInfo invocationName = InvocationInfo.assertInvocation((String)"ShouldHaveExpectedResult", (Object[])new Object[]{this});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            AtomicBoolean match = new AtomicBoolean(false);
            result.getResults().forEach((index, value) -> {
                if (this.expectedResult.equals(value)) {
                    match.set(true);
                }
            });
            if (!match.get()) {
                throw ResultVerification.assertionError((String)PageFactoryWebApiMessages.FILTERED_ELEMENT_DOES_NOT_CONTAIN_EXPECTED_RESULT.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
            }
        });
    }
}

