/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.result.implementations;

import io.perfeccionista.framework.exceptions.WebElementIndex;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.result.WebIndexesMatcher;
import io.perfeccionista.framework.pagefactory.elements.base.WebChildElement;
import io.perfeccionista.framework.result.WebMultipleIndexedResult;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveIndexNumberMatcher
implements WebIndexesMatcher {
    private final int expectedIndex;
    private final boolean positive;

    public WebShouldHaveIndexNumberMatcher(int expectedIndex, boolean positive) {
        this.expectedIndex = expectedIndex;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebMultipleIndexedResult<Integer, ? extends WebChildElement> result) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveIndex", (Object[])new Object[]{this, this.expectedIndex}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveIndex", (Object[])new Object[]{this, this.expectedIndex});
        WebChildElement element = result.getElement();
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            Collection<Integer> indexes = result.getResults().values();
            boolean actualValue = indexes.stream().anyMatch(index -> this.expectedIndex == index);
            if (this.positive) {
                this.shouldHaveIndex(element, actualValue, indexes);
            } else {
                this.shouldNotHaveIndex(element, actualValue, indexes);
            }
        });
    }

    protected void shouldHaveIndex(WebChildElement element, boolean actualValue, Collection<Integer> indexes) {
        if (!actualValue) {
            throw WebElementIndex.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_DOES_NOT_CONTAIN_INDEX.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)String.valueOf(this.expectedIndex), (String)this.indexesToString(indexes)));
        }
    }

    protected void shouldNotHaveIndex(WebChildElement element, boolean actualValue, Collection<Integer> indexes) {
        if (actualValue) {
            throw WebElementIndex.assertionError(PageFactoryWebApiMessages.FILTERED_ELEMENT_CONTAINS_INDEX.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)String.valueOf(this.expectedIndex), (String)this.indexesToString(indexes)));
        }
    }

    private String indexesToString(Collection<Integer> indexes) {
        return indexes.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

