/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementScreenshot;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ScreenshotAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetScreenshotAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetScreenshotAvailable;
import io.perfeccionista.framework.screenshots.Screenshot;
import org.jetbrains.annotations.NotNull;

public class WebShouldLooksLikeMatcher
implements WebGetScreenshotAvailableMatcher {
    private final String componentName;
    private final Screenshot expectedScreenshot;
    private final boolean positive;

    public WebShouldLooksLikeMatcher(@NotNull String componentName, @NotNull Screenshot expectedScreenshot, boolean positive) {
        this.componentName = componentName;
        this.expectedScreenshot = expectedScreenshot;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetScreenshotAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldLooksLike", (Object[])new Object[]{element, this.componentName, this.expectedScreenshot}) : InvocationInfo.assertInvocation((String)"ShouldNotLooksLike", (Object[])new Object[]{element, this.componentName, this.expectedScreenshot});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            Screenshot actualScreenshot = element.getScreenshot(this.componentName);
            if (this.positive) {
                this.shouldLooksLike(element, actualScreenshot, this.expectedScreenshot, this.componentName);
            } else {
                this.shouldNotLooksLike(element, actualScreenshot, this.expectedScreenshot, this.componentName);
            }
        });
    }

    protected void shouldLooksLike(WebGetScreenshotAvailable element, Screenshot actualScreenshot, Screenshot expectedScreenshot, String componentName) {
        if (!expectedScreenshot.equals(actualScreenshot)) {
            throw WebElementScreenshot.assertionError(PageFactoryWebApiMessages.ELEMENT_SCREENSHOT_IS_NOT_EQUAL_EXPECTED_SCREENSHOT.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)ScreenshotAttachmentEntry.of((String)"Actual screenshot", (Screenshot)actualScreenshot)).addLastAttachmentEntry((AttachmentEntry)ScreenshotAttachmentEntry.of((String)"Expected screenshot", (Screenshot)expectedScreenshot));
        }
    }

    protected void shouldNotLooksLike(WebGetScreenshotAvailable element, Screenshot actualScreenshot, Screenshot expectedScreenshot, String componentName) {
        if (expectedScreenshot.equals(actualScreenshot)) {
            throw WebElementScreenshot.assertionError(PageFactoryWebApiMessages.ELEMENT_SCREENSHOT_IS_EQUAL_EXPECTED_SCREENSHOT.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)ScreenshotAttachmentEntry.of((String)"Actual screenshot", (Screenshot)actualScreenshot)).addLastAttachmentEntry((AttachmentEntry)ScreenshotAttachmentEntry.of((String)"Expected screenshot", (Screenshot)expectedScreenshot));
        }
    }
}

