/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.WebElementTextValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetTextAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetTextAvailable;
import io.perfeccionista.framework.value.string.StringValue;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveTextStringValueMatcher
implements WebGetTextAvailableMatcher {
    private final StringValue expectedStringValue;
    private final boolean positive;

    public WebShouldHaveTextStringValueMatcher(@NotNull StringValue expectedStringValue, boolean positive) {
        this.expectedStringValue = expectedStringValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetTextAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveText", (Object[])new Object[]{this, this.expectedStringValue}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveText", (Object[])new Object[]{this, this.expectedStringValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualText = element.getText();
            if (this.positive) {
                this.shouldHaveText(element, actualText);
            } else {
                this.shouldNotHaveText(element, actualText);
            }
        });
    }

    protected void shouldHaveText(WebGetTextAvailable element, String actualText) {
        if (!this.expectedStringValue.check((Object)actualText)) {
            throw WebElementTextValue.assertionError(PageFactoryWebApiMessages.ELEMENT_TEXT_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }

    protected void shouldNotHaveText(WebGetTextAvailable element, String actualText) {
        if (this.expectedStringValue.check((Object)actualText)) {
            throw WebElementTextValue.assertionError(PageFactoryWebApiMessages.ELEMENT_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }
}

