/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.ElementDoesNotHaveExpectedState;
import io.perfeccionista.framework.exceptions.ElementHasUnexpectedState;
import io.perfeccionista.framework.exceptions.ElementStateNotFound;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebElementStateAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebElementStateAvailable;
import io.perfeccionista.framework.pagefactory.elements.states.base.WebElementStateHolder;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperation;
import io.perfeccionista.framework.pagefactory.operation.WebElementOperationResult;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveStateMatcher
implements WebElementStateAvailableMatcher {
    private final String stateName;
    private final boolean positive;

    public WebShouldHaveStateMatcher(@NotNull String stateName, boolean positive) {
        this.stateName = stateName;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebElementStateAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveState", (Object[])new Object[]{element, this.stateName}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveState", (Object[])new Object[]{element, this.stateName});
        WebElementStateHolder stateHolder = element.getState(this.stateName).orElseThrow(() -> ElementStateNotFound.exception((String)PageFactoryApiMessages.ELEMENT_STATE_NOT_FOUND.getMessage(new Object[]{this.stateName})).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)));
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            if (this.positive) {
                this.shouldHaveState(element, stateHolder);
            } else {
                this.shouldNotHaveState(element, stateHolder);
            }
        });
    }

    protected void shouldHaveState(WebElementStateAvailable element, WebElementStateHolder stateHolder) {
        WebElementOperation<Boolean> operation = stateHolder.getOperation(element).withPageSource();
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            throw exceptionMapper.mapElementException(element, (RuntimeException)originalException);
        });
        if (operationResult.hasResult()) {
            boolean result = operationResult.getNotNullResult();
            if (!result) {
                throw ElementDoesNotHaveExpectedState.assertionError((String)PageFactoryApiMessages.ELEMENT_DOES_NOT_HAVE_EXPECTED_STATE.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName(), this.stateName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"PageSource", (String)operationResult.getPageSource()));
            }
            return;
        }
        throw ElementDoesNotHaveExpectedState.assertionError((String)PageFactoryApiMessages.ELEMENT_DOES_NOT_HAVE_EXPECTED_STATE.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName(), this.stateName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"PageSource", (String)operationResult.getPageSource()));
    }

    protected void shouldNotHaveState(WebElementStateAvailable element, WebElementStateHolder stateHolder) {
        boolean result;
        WebElementOperation<Boolean> operation = stateHolder.getOperation(element);
        WebElementOperationResult<Boolean> operationResult = element.getWebBrowserDispatcher().executor().executeWebElementOperation(operation).ifException((exceptionMapper, originalException) -> {
            throw exceptionMapper.mapElementException(element, (RuntimeException)originalException);
        });
        if (operationResult.hasResult() && (result = operationResult.getNotNullResult().booleanValue())) {
            throw ElementHasUnexpectedState.assertionError((String)PageFactoryApiMessages.ELEMENT_HAS_UNEXPECTED_STATE.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName(), this.stateName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"PageSource", (String)operationResult.getPageSource()));
        }
    }
}

