/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementLocation;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetElementBoundsAvailableMatcher;
import io.perfeccionista.framework.measurements.Point2D;
import io.perfeccionista.framework.pagefactory.elements.ElementBounds;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetElementBoundsAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveScreenLocationMatcher
implements WebGetElementBoundsAvailableMatcher {
    private final String componentName;
    private final Point2D expectedLocation;
    private final boolean positive;

    public WebShouldHaveScreenLocationMatcher(@NotNull String componentName, @NotNull Point2D expectedLocation, boolean positive) {
        this.componentName = componentName;
        this.expectedLocation = expectedLocation;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetElementBoundsAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveScreenLocation", (Object[])new Object[]{element, this.componentName, this.expectedLocation}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveScreenLocation", (Object[])new Object[]{element, this.componentName, this.expectedLocation});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            ElementBounds actualElementBounds = element.getElementBounds(this.componentName);
            if (this.positive) {
                this.shouldHaveLocation(element, actualElementBounds.getScreenLocation(), this.expectedLocation, this.componentName);
            } else {
                this.shouldNotHaveLocation(element, actualElementBounds.getScreenLocation(), this.expectedLocation, this.componentName);
            }
        });
    }

    protected void shouldHaveLocation(WebGetElementBoundsAvailable element, Point2D actualLocation, Point2D expectedLocation, String componentName) {
        if (!expectedLocation.equals((Object)actualLocation)) {
            throw WebElementLocation.assertionError(PageFactoryWebApiMessages.ELEMENT_LOCATION_IS_NOT_EQUAL_EXPECTED_LOCATION.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual location", (String)actualLocation.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected location", (String)expectedLocation.toString()));
        }
    }

    protected void shouldNotHaveLocation(WebGetElementBoundsAvailable element, Point2D actualLocation, Point2D expectedLocation, String componentName) {
        if (expectedLocation.equals((Object)actualLocation)) {
            throw WebElementLocation.assertionError(PageFactoryWebApiMessages.ELEMENT_LOCATION_IS_EQUAL_EXPECTED_LOCATION.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual location", (String)actualLocation.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected location", (String)expectedLocation.toString()));
        }
    }
}

