/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementPropertyValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebElementPropertyAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebElementPropertyAvailable;
import io.perfeccionista.framework.value.string.StringValue;
import org.jetbrains.annotations.NotNull;

public class WebShouldHavePropertyStringValueMatcher
implements WebElementPropertyAvailableMatcher {
    private final String propertyName;
    private final StringValue expectedStringValue;
    private final boolean positive;

    public WebShouldHavePropertyStringValueMatcher(@NotNull String propertyName, @NotNull StringValue expectedStringValue, boolean positive) {
        this.propertyName = propertyName;
        this.expectedStringValue = expectedStringValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebElementPropertyAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHavePropertyValue", (Object[])new Object[]{this, this.propertyName, this.expectedStringValue}) : InvocationInfo.assertInvocation((String)"ShouldNotHavePropertyValue", (Object[])new Object[]{this, this.propertyName, this.expectedStringValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualPropertyValue = element.getPropertyValue(this.propertyName);
            if (this.positive) {
                this.shouldHavePropertyValue(element, actualPropertyValue);
            } else {
                this.shouldNotHavePropertyValue(element, actualPropertyValue);
            }
        });
    }

    protected void shouldHavePropertyValue(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (!this.expectedStringValue.check((Object)actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected value", (String)this.expectedStringValue.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }

    protected void shouldNotHavePropertyValue(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (this.expectedStringValue.check((Object)actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_CONTAINS_EXPECTED_VALUE.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected value", (String)this.expectedStringValue.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }
}

