/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementPropertyValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebElementPropertyAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebElementPropertyAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldHavePropertyStringMatcher
implements WebElementPropertyAvailableMatcher {
    private final String propertyName;
    private final String expectedText;
    private final boolean positive;

    public WebShouldHavePropertyStringMatcher(@NotNull String propertyName, @NotNull String expectedText, boolean positive) {
        this.propertyName = propertyName;
        this.expectedText = expectedText;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebElementPropertyAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHavePropertyText", (Object[])new Object[]{this, this.propertyName, this.expectedText}) : InvocationInfo.assertInvocation((String)"ShouldNotHavePropertyText", (Object[])new Object[]{this, this.propertyName, this.expectedText});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualPropertyValue = element.getPropertyValue(this.propertyName);
            if (this.positive) {
                this.shouldHavePropertyText(element, actualPropertyValue);
            } else {
                this.shouldNotHavePropertyText(element, actualPropertyValue);
            }
        });
    }

    protected void shouldHavePropertyText(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (!this.expectedText.equals(actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_DOES_NOT_CONTAIN_EXPECTED_TEXT.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected text", (String)this.expectedText)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }

    protected void shouldNotHavePropertyText(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (this.expectedText.equals(actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_CONTAINS_EXPECTED_TEXT.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected text", (String)this.expectedText)).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }
}

