/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementPropertyValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebElementPropertyAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebElementPropertyAvailable;
import io.perfeccionista.framework.value.number.NumberValue;
import org.jetbrains.annotations.NotNull;

public class WebShouldHavePropertyNumberValueMatcher
implements WebElementPropertyAvailableMatcher {
    private final String propertyName;
    private final NumberValue<? extends Number> expectedNumberValue;
    private final boolean positive;

    public WebShouldHavePropertyNumberValueMatcher(@NotNull String propertyName, @NotNull NumberValue<? extends Number> expectedNumberValue, boolean positive) {
        this.propertyName = propertyName;
        this.expectedNumberValue = expectedNumberValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebElementPropertyAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHavePropertyNumber", (Object[])new Object[]{this, this.propertyName, this.expectedNumberValue}) : InvocationInfo.assertInvocation((String)"ShouldNotHavePropertyNumber", (Object[])new Object[]{this, this.propertyName, this.expectedNumberValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualPropertyValue = element.getPropertyValue(this.propertyName);
            if (this.positive) {
                this.shouldHavePropertyNumber(element, actualPropertyValue);
            } else {
                this.shouldNotHavePropertyNumber(element, actualPropertyValue);
            }
        });
    }

    protected void shouldHavePropertyNumber(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (!this.expectedNumberValue.checkString(actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected value", (String)this.expectedNumberValue.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }

    protected void shouldNotHavePropertyNumber(WebElementPropertyAvailable element, String actualPropertyValue) {
        if (this.expectedNumberValue.checkString(actualPropertyValue)) {
            throw WebElementPropertyValue.assertionError(PageFactoryWebApiMessages.ELEMENT_PROPERTY_CONTAINS_EXPECTED_VALUE.getMessage(new Object[]{this.propertyName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected value", (String)this.expectedNumberValue.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual value", (String)actualPropertyValue));
        }
    }
}

