/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.WebElementLabelValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetLabelAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetLabelAvailable;
import io.perfeccionista.framework.value.string.StringValue;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveLabelStringValueMatcher
implements WebGetLabelAvailableMatcher {
    private final StringValue expectedStringValue;
    private final boolean positive;

    public WebShouldHaveLabelStringValueMatcher(@NotNull StringValue expectedStringValue, boolean positive) {
        this.expectedStringValue = expectedStringValue;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetLabelAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveTextLabel", (Object[])new Object[]{this, this.expectedStringValue}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveTextLabel", (Object[])new Object[]{this, this.expectedStringValue});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualLabel = element.getLabel();
            if (this.positive) {
                this.shouldHaveLabel(element, actualLabel);
            } else {
                this.shouldNotHaveLabel(element, actualLabel);
            }
        });
    }

    protected void shouldHaveLabel(WebGetLabelAvailable element, String actualLabel) {
        if (!this.expectedStringValue.check((Object)actualLabel)) {
            throw WebElementLabelValue.assertionError(PageFactoryWebApiMessages.ELEMENT_LABEL_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }

    protected void shouldNotHaveLabel(WebGetLabelAvailable element, String actualLabel) {
        if (this.expectedStringValue.check((Object)actualLabel)) {
            throw WebElementLabelValue.assertionError(PageFactoryWebApiMessages.ELEMENT_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((StringValue)this.expectedStringValue));
        }
    }
}

