/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.WebElementLabelValue;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.ValueAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetLabelAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetLabelAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveLabelStringMatcher
implements WebGetLabelAvailableMatcher {
    private final String expectedText;
    private final boolean positive;

    public WebShouldHaveLabelStringMatcher(@NotNull String expectedText, boolean positive) {
        this.expectedText = expectedText;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetLabelAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveTextLabel", (Object[])new Object[]{this, this.expectedText}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveTextLabel", (Object[])new Object[]{this, this.expectedText});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            String actualLabel = element.getLabel();
            if (this.positive) {
                this.shouldHaveLabel(element, actualLabel);
            } else {
                this.shouldNotHaveLabel(element, actualLabel);
            }
        });
    }

    protected void shouldHaveLabel(WebGetLabelAvailable element, String actualLabel) {
        if (!this.expectedText.equals(actualLabel)) {
            throw WebElementLabelValue.assertionError(PageFactoryWebApiMessages.ELEMENT_LABEL_DOES_NOT_CONTAIN_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualLabel));
        }
    }

    protected void shouldNotHaveLabel(WebGetLabelAvailable element, String actualLabel) {
        if (this.expectedText.equals(actualLabel)) {
            throw WebElementLabelValue.assertionError(PageFactoryWebApiMessages.ELEMENT_TEXT_CONTAINS_EXPECTED_VALUE.getMessage(new Object[0])).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element)).addLastAttachmentEntry((AttachmentEntry)ValueAttachmentEntry.of((String)this.expectedText, (String)actualLabel));
        }
    }
}

