/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementDimensions;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetElementBoundsAvailableMatcher;
import io.perfeccionista.framework.measurements.Dimensions2D;
import io.perfeccionista.framework.pagefactory.elements.ElementBounds;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetElementBoundsAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveDimensionsMatcher
implements WebGetElementBoundsAvailableMatcher {
    private final String componentName;
    private final Dimensions2D expectedDimensions;
    private final boolean positive;

    public WebShouldHaveDimensionsMatcher(@NotNull String componentName, @NotNull Dimensions2D expectedDimensions, boolean positive) {
        this.componentName = componentName;
        this.expectedDimensions = expectedDimensions;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetElementBoundsAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveDimensions", (Object[])new Object[]{element, this.componentName, this.expectedDimensions}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveDimensions", (Object[])new Object[]{element, this.componentName, this.expectedDimensions});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            ElementBounds actualElementBounds = element.getElementBounds(this.componentName);
            if (this.positive) {
                this.shouldHaveDimensions(element, actualElementBounds.getDimensions(), this.expectedDimensions, this.componentName);
            } else {
                this.shouldNotHaveDimensions(element, actualElementBounds.getDimensions(), this.expectedDimensions, this.componentName);
            }
        });
    }

    protected void shouldHaveDimensions(WebGetElementBoundsAvailable element, Dimensions2D actualDimensions, Dimensions2D expectedDimensions, String componentName) {
        if (!expectedDimensions.equals((Object)actualDimensions)) {
            throw WebElementDimensions.assertionError(PageFactoryWebApiMessages.ELEMENT_DIMENSIONS_ARE_NOT_EQUAL_EXPECTED_DIMENSIONS.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual dimensions", (String)actualDimensions.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected dimensions", (String)expectedDimensions.toString()));
        }
    }

    protected void shouldNotHaveDimensions(WebGetElementBoundsAvailable element, Dimensions2D actualDimensions, Dimensions2D expectedDimensions, String componentName) {
        if (expectedDimensions.equals((Object)actualDimensions)) {
            throw WebElementDimensions.assertionError(PageFactoryWebApiMessages.ELEMENT_DIMENSIONS_ARE_EQUAL_EXPECTED_DIMENSIONS.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual dimensions", (String)actualDimensions.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected dimensions", (String)expectedDimensions.toString()));
        }
    }
}

