/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.color.Color;
import io.perfeccionista.framework.exceptions.WebElementColor;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.TextAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebGetColorAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebGetColorAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldHaveColorMatcher
implements WebGetColorAvailableMatcher {
    private final String componentName;
    private final String cssProperty;
    private final Color expectedColor;
    private final boolean positive;

    public WebShouldHaveColorMatcher(@NotNull String componentName, @NotNull String cssProperty, @NotNull Color expectedColor, boolean positive) {
        this.componentName = componentName;
        this.cssProperty = cssProperty;
        this.expectedColor = expectedColor;
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebGetColorAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldHaveColor", (Object[])new Object[]{element, this.componentName, this.cssProperty, this.expectedColor}) : InvocationInfo.assertInvocation((String)"ShouldNotHaveColor", (Object[])new Object[]{element, this.componentName, this.cssProperty, this.expectedColor});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            Color actualColor = element.getColor(this.componentName, this.cssProperty);
            if (this.positive) {
                this.shouldHaveColor(element, actualColor, this.expectedColor, this.componentName);
            } else {
                this.shouldNotHaveColor(element, actualColor, this.expectedColor, this.componentName);
            }
        });
    }

    protected void shouldHaveColor(WebGetColorAvailable element, Color actualColor, Color expectedColor, String componentName) {
        if (!expectedColor.equals((Object)actualColor)) {
            throw WebElementColor.assertionError(PageFactoryWebApiMessages.ELEMENT_COLOR_IS_NOT_EQUAL_EXPECTED_COLOR.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual color", (String)actualColor.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected color", (String)expectedColor.toString()));
        }
    }

    protected void shouldNotHaveColor(WebGetColorAvailable element, Color actualColor, Color expectedColor, String componentName) {
        if (expectedColor.equals((Object)actualColor)) {
            throw WebElementColor.assertionError(PageFactoryWebApiMessages.ELEMENT_COLOR_IS_EQUAL_EXPECTED_COLOR.getMessage(new Object[]{componentName})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Actual color", (String)actualColor.toString())).addLastAttachmentEntry((AttachmentEntry)TextAttachmentEntry.of((String)"Expected color", (String)expectedColor.toString()));
        }
    }
}

