/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import io.perfeccionista.framework.exceptions.ElementIsSelected;
import io.perfeccionista.framework.exceptions.WebElementNotSelected;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.WebElementAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebIsSelectedAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsSelectedAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldBeSelectedMatcher
implements WebIsSelectedAvailableMatcher {
    private final boolean positive;

    public WebShouldBeSelectedMatcher(boolean positive) {
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebIsSelectedAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldBeSelected", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ShouldNotBeSelected", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            boolean selected = element.isSelected();
            if (this.positive) {
                this.shouldBeSelected(element, selected);
            } else {
                this.shouldNotBeSelected(element, selected);
            }
        });
    }

    protected void shouldBeSelected(WebIsSelectedAvailable element, boolean selected) {
        if (!selected) {
            throw WebElementNotSelected.assertionError(PageFactoryWebApiMessages.ELEMENT_NOT_SELECTED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        }
    }

    protected void shouldNotBeSelected(WebIsSelectedAvailable element, boolean selected) {
        if (selected) {
            throw ElementIsSelected.assertionError((String)PageFactoryWebApiMessages.ELEMENT_IS_SELECTED.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)WebElementAttachmentEntry.of(element));
        }
    }
}

