/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.ElementNotOnTheScreen;
import io.perfeccionista.framework.exceptions.WebElementOnTheScreen;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryApiMessages;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebIsOnTheScreenAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsOnTheScreenAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldBeOnTheScreenMatcher
implements WebIsOnTheScreenAvailableMatcher {
    private final boolean positive;

    public WebShouldBeOnTheScreenMatcher(boolean positive) {
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebIsOnTheScreenAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldBeOnTheScreen", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ShouldNotBeOnTheScreen", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            boolean onTheScreen = element.isOnTheScreen();
            if (this.positive) {
                this.shouldBeOnTheScreen(element, onTheScreen);
            } else {
                this.shouldNotBeOnTheScreen(element, onTheScreen);
            }
        });
    }

    protected void shouldBeOnTheScreen(WebIsOnTheScreenAvailable element, boolean onTheScreen) {
        if (!onTheScreen) {
            throw ElementNotOnTheScreen.assertionError((String)PageFactoryApiMessages.ELEMENT_NOT_ON_THE_SCREEN.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        }
    }

    protected void shouldNotBeOnTheScreen(WebIsOnTheScreenAvailable element, boolean onTheScreen) {
        if (onTheScreen) {
            throw WebElementOnTheScreen.assertionError(PageFactoryWebApiMessages.ELEMENT_ON_THE_SCREEN.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        }
    }
}

