/*
 * Decompiled with CFR 0.152.
 */
package io.perfeccionista.framework.matcher.methods.implementations;

import com.fasterxml.jackson.databind.JsonNode;
import io.perfeccionista.framework.exceptions.WebElementInFocus;
import io.perfeccionista.framework.exceptions.WebElementNotInFocus;
import io.perfeccionista.framework.exceptions.attachments.AttachmentEntry;
import io.perfeccionista.framework.exceptions.attachments.JsonAttachmentEntry;
import io.perfeccionista.framework.exceptions.messages.PageFactoryWebApiMessages;
import io.perfeccionista.framework.invocation.runner.InvocationInfo;
import io.perfeccionista.framework.invocation.wrapper.CheckInvocationWrapper;
import io.perfeccionista.framework.matcher.methods.WebIsInFocusAvailableMatcher;
import io.perfeccionista.framework.pagefactory.elements.methods.WebIsInFocusAvailable;
import org.jetbrains.annotations.NotNull;

public class WebShouldBeInFocusMatcher
implements WebIsInFocusAvailableMatcher {
    private final boolean positive;

    public WebShouldBeInFocusMatcher(boolean positive) {
        this.positive = positive;
    }

    @Override
    public void check(@NotNull WebIsInFocusAvailable element) {
        InvocationInfo invocationName = this.positive ? InvocationInfo.assertInvocation((String)"ShouldBeInFocus", (Object[])new Object[]{element}) : InvocationInfo.assertInvocation((String)"ShouldNotBeInFocus", (Object[])new Object[]{element});
        CheckInvocationWrapper.runCheck((InvocationInfo)invocationName, () -> {
            boolean inFocus = element.isInFocus();
            if (this.positive) {
                this.shouldBeInFocus(element, inFocus);
            } else {
                this.shouldNotBeInFocus(element, inFocus);
            }
        });
    }

    protected void shouldBeInFocus(WebIsInFocusAvailable element, boolean inFocus) {
        if (!inFocus) {
            throw WebElementNotInFocus.assertionError(PageFactoryWebApiMessages.ELEMENT_NOT_IN_FOCUS.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        }
    }

    protected void shouldNotBeInFocus(WebIsInFocusAvailable element, boolean inFocus) {
        if (inFocus) {
            throw WebElementInFocus.assertionError(PageFactoryWebApiMessages.ELEMENT_IN_FOCUS.getMessage(new Object[]{element.getElementIdentifier().getLastUsedName()})).setProcessed(true).addLastAttachmentEntry((AttachmentEntry)JsonAttachmentEntry.of((String)"Element", (JsonNode)element.toJson()));
        }
    }
}

